/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.auth.keyboard;

import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.common.util.GenericUtils;
import java.util.List;

public interface UserInteraction {
    public static final String AUTO_DETECT_PASSWORD_PROMPT = "user-interaction-auto-detect-password-prompt";
    public static final boolean DEFAULT_AUTO_DETECT_PASSWORD_PROMPT = true;
    public static final String INTERACTIVE_PASSWORD_PROMPT = "user-interaction-password-prompt";
    public static final String DEFAULT_INTERACTIVE_PASSWORD_PROMPT = "password";
    public static final String CHECK_INTERACTIVE_PASSWORD_DELIM = "user-interaction-check-password-delimiter";
    public static final String DEFAULT_CHECK_INTERACTIVE_PASSWORD_DELIM = ":";
    public static final UserInteraction NONE = new UserInteraction(){

        @Override
        public boolean isInteractionAllowed(ClientSession session) {
            return false;
        }

        @Override
        public String[] interactive(ClientSession session, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
            throw new IllegalStateException("interactive(" + session + ")[" + name + "] unexpected call");
        }

        @Override
        public String getUpdatedPassword(ClientSession session, String prompt, String lang) {
            throw new IllegalStateException("getUpdatedPassword(" + session + ")[" + prompt + "] unexpected call");
        }

        public String toString() {
            return "NONE";
        }
    };

    default public boolean isInteractionAllowed(ClientSession session) {
        return true;
    }

    default public void serverVersionInfo(ClientSession session, List<String> lines) {
    }

    default public void welcome(ClientSession session, String banner, String lang) {
    }

    public String[] interactive(ClientSession var1, String var2, String var3, String var4, String[] var5, boolean[] var6);

    public String getUpdatedPassword(ClientSession var1, String var2, String var3);

    public static int findPromptComponentLastPosition(String prompt, String tokensList) {
        String[] tokens;
        if (GenericUtils.isEmpty(prompt) || GenericUtils.isEmpty(tokensList)) {
            return -1;
        }
        for (String t : tokens = GenericUtils.split(tokensList, ',')) {
            int pos = prompt.lastIndexOf(t);
            if (pos < 0) continue;
            return pos;
        }
        return -1;
    }
}

