/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client;

import axion.org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import axion.org.apache.sshd.client.auth.BuiltinUserAuthFactories;
import axion.org.apache.sshd.client.auth.UserAuth;
import axion.org.apache.sshd.client.auth.UserAuthFactory;
import axion.org.apache.sshd.client.auth.keyboard.UserInteraction;
import axion.org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import axion.org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.common.auth.UserAuthFactoriesManager;
import axion.org.apache.sshd.common.keyprovider.KeyIdentityProviderHolder;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import java.security.KeyPair;
import java.util.Collection;
import java.util.List;

public interface ClientAuthenticationManager
extends UserAuthFactoriesManager<ClientSession, UserAuth, UserAuthFactory>,
KeyIdentityProviderHolder {
    public AuthenticationIdentitiesProvider getRegisteredIdentities();

    public PasswordIdentityProvider getPasswordIdentityProvider();

    public void setPasswordIdentityProvider(PasswordIdentityProvider var1);

    public void addPasswordIdentity(String var1);

    public String removePasswordIdentity(String var1);

    public void addPublicKeyIdentity(KeyPair var1);

    public KeyPair removePublicKeyIdentity(KeyPair var1);

    public ServerKeyVerifier getServerKeyVerifier();

    public void setServerKeyVerifier(ServerKeyVerifier var1);

    public UserInteraction getUserInteraction();

    public void setUserInteraction(UserInteraction var1);

    @Override
    default public void setUserAuthFactoriesNames(Collection<String> names) {
        BuiltinUserAuthFactories.ParseResult result = BuiltinUserAuthFactories.parseFactoriesList(names);
        List factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported user authentication factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported user authentication factories found: %s", unsupported);
        this.setUserAuthFactories(factories);
    }
}

