/*
 * Decompiled with CFR 0.152.
 */
package axion.net.i2p.crypto.eddsa.spec;

import axion.net.i2p.crypto.eddsa.math.GroupElement;
import axion.net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import java.security.spec.KeySpec;

public class EdDSAPublicKeySpec
implements KeySpec {
    private final GroupElement A;
    private GroupElement Aneg = null;
    private final EdDSAParameterSpec spec;

    public EdDSAPublicKeySpec(byte[] pk, EdDSAParameterSpec spec) {
        if (pk.length != spec.getCurve().getField().getb() / 8) {
            throw new IllegalArgumentException("public-key length is wrong");
        }
        this.A = new GroupElement(spec.getCurve(), pk);
        this.spec = spec;
    }

    public EdDSAPublicKeySpec(GroupElement A, EdDSAParameterSpec spec) {
        this.A = A;
        this.spec = spec;
    }

    public GroupElement getA() {
        return this.A;
    }

    public GroupElement getNegativeA() {
        GroupElement ourAneg = this.Aneg;
        if (ourAneg == null) {
            this.Aneg = ourAneg = this.A.negate();
        }
        return ourAneg;
    }

    public EdDSAParameterSpec getParams() {
        return this.spec;
    }
}

