/*
 * Decompiled with CFR 0.152.
 */
package axion.com.jcraft.jsch.agentproxy;

import axion.com.jcraft.jsch.agentproxy.AgentProxyException;
import axion.com.jcraft.jsch.agentproxy.Buffer;
import axion.com.jcraft.jsch.agentproxy.Connector;
import axion.com.jcraft.jsch.agentproxy.Identity;

public class AgentProxy {
    private static final byte SSH_AGENTC_REQUEST_RSA_IDENTITIES = 1;
    private static final byte SSH_AGENT_RSA_IDENTITIES_ANSWER = 2;
    private static final byte SSH_AGENTC_RSA_CHALLENGE = 3;
    private static final byte SSH_AGENT_RSA_RESPONSE = 4;
    private static final byte SSH_AGENT_FAILURE = 5;
    private static final byte SSH_AGENT_SUCCESS = 6;
    private static final byte SSH_AGENTC_ADD_RSA_IDENTITY = 7;
    private static final byte SSH_AGENTC_REMOVE_RSA_IDENTITY = 8;
    private static final byte SSH_AGENTC_REMOVE_ALL_RSA_IDENTITIES = 9;
    private static final byte SSH2_AGENTC_REQUEST_IDENTITIES = 11;
    private static final byte SSH2_AGENT_IDENTITIES_ANSWER = 12;
    private static final byte SSH2_AGENTC_SIGN_REQUEST = 13;
    private static final byte SSH2_AGENT_SIGN_RESPONSE = 14;
    private static final byte SSH2_AGENTC_ADD_IDENTITY = 17;
    private static final byte SSH2_AGENTC_REMOVE_IDENTITY = 18;
    private static final byte SSH2_AGENTC_REMOVE_ALL_IDENTITIES = 19;
    private static final byte SSH_AGENTC_ADD_SMARTCARD_KEY = 20;
    private static final byte SSH_AGENTC_REMOVE_SMARTCARD_KEY = 21;
    private static final byte SSH_AGENTC_LOCK = 22;
    private static final byte SSH_AGENTC_UNLOCK = 23;
    private static final byte SSH_AGENTC_ADD_RSA_ID_CONSTRAINED = 24;
    private static final byte SSH2_AGENTC_ADD_ID_CONSTRAINED = 25;
    private static final byte SSH_AGENTC_ADD_SMARTCARD_KEY_CONSTRAINED = 26;
    private static final byte SSH_AGENT_CONSTRAIN_LIFETIME = 1;
    private static final byte SSH_AGENT_CONSTRAIN_CONFIRM = 2;
    private static final byte SSH2_AGENT_FAILURE = 30;
    private static final byte SSH_COM_AGENT2_FAILURE = 102;
    private static final byte SSH_AGENT_OLD_SIGNATURE = 1;
    private final byte[] buf = new byte[1024];
    private final Buffer buffer = new Buffer(this.buf);
    private Connector connector;

    public AgentProxy(Connector connector) {
        this.connector = connector;
    }

    public synchronized Identity[] getIdentities() {
        Identity[] identities = null;
        byte code1 = 11;
        int code2 = 12;
        this.buffer.reset();
        this.buffer.putByte(code1);
        this.buffer.insertLength();
        try {
            this.connector.query(this.buffer);
        }
        catch (AgentProxyException e) {
            this.buffer.rewind();
            this.buffer.putByte((byte)5);
            identities = new Identity[]{};
            return identities;
        }
        int rcode = this.buffer.getByte();
        this.check_reply(rcode);
        int count = this.buffer.getInt();
        identities = new Identity[count];
        for (int i = 0; i < identities.length; ++i) {
            identities[i] = new Identity(this.buffer.getString(), this.buffer.getString());
        }
        return identities;
    }

    public synchronized byte[] sign(byte[] blob, byte[] data) {
        byte[] result = null;
        byte code1 = 13;
        int code2 = 14;
        int required_size = 17 + blob.length + data.length;
        this.buffer.reset();
        this.buffer.checkFreeSize(required_size);
        this.buffer.putByte(code1);
        this.buffer.putString(blob);
        this.buffer.putString(data);
        this.buffer.putInt(0);
        this.buffer.insertLength();
        try {
            this.connector.query(this.buffer);
        }
        catch (AgentProxyException e) {
            this.buffer.rewind();
            this.buffer.putByte((byte)5);
        }
        int rcode = this.buffer.getByte();
        this.check_reply(rcode);
        result = this.buffer.getString();
        return result;
    }

    public synchronized boolean removeIdentity(byte[] blob) {
        byte code1 = 18;
        int required_size = 9 + blob.length;
        this.buffer.reset();
        this.buffer.checkFreeSize(required_size);
        this.buffer.putByte(code1);
        this.buffer.putString(blob);
        this.buffer.insertLength();
        try {
            this.connector.query(this.buffer);
        }
        catch (AgentProxyException e) {
            this.buffer.rewind();
            this.buffer.putByte((byte)5);
        }
        this.check_reply(this.buffer.getByte());
        return true;
    }

    public synchronized void removeAllIdentities() {
        byte code1 = 19;
        this.buffer.reset();
        this.buffer.putByte(code1);
        this.buffer.insertLength();
        try {
            this.connector.query(this.buffer);
        }
        catch (AgentProxyException e) {
            this.buffer.rewind();
            this.buffer.putByte((byte)5);
        }
        this.check_reply(this.buffer.getByte());
    }

    public synchronized boolean addIdentity(byte[] identity) {
        byte code1 = 17;
        int required_size = 5 + identity.length;
        this.buffer.reset();
        this.buffer.checkFreeSize(required_size);
        this.buffer.putByte(code1);
        this.buffer.putByte(identity);
        this.buffer.insertLength();
        try {
            this.connector.query(this.buffer);
        }
        catch (AgentProxyException e) {
            this.buffer.rewind();
            this.buffer.putByte((byte)5);
        }
        this.check_reply(this.buffer.getByte());
        return true;
    }

    public synchronized boolean isRunning() {
        if (!this.connector.isAvailable()) {
            return false;
        }
        byte code1 = 11;
        this.buffer.reset();
        this.buffer.putByte(code1);
        this.buffer.insertLength();
        try {
            this.connector.query(this.buffer);
        }
        catch (AgentProxyException e) {
            return false;
        }
        return this.buffer.getByte() == 12;
    }

    public synchronized Connector getConnector() {
        return this.connector;
    }

    private boolean check_reply(int typ) {
        return true;
    }
}

