/*
 * Decompiled with CFR 0.152.
 */
package axion.com.googlecode.javaewah;

import axion.com.googlecode.javaewah.Buffer;
import axion.com.googlecode.javaewah.EWAHIterator;
import axion.com.googlecode.javaewah.IntIterator;
import axion.com.googlecode.javaewah.RunningLengthWord;

final class ClearIntIterator
implements IntIterator {
    private final EWAHIterator ewahIter;
    private final int sizeInBits;
    private final Buffer buffer;
    private int position;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    ClearIntIterator(EWAHIterator ewahIter, int sizeInBits) {
        this.ewahIter = ewahIter;
        this.sizeInBits = sizeInBits;
        this.buffer = ewahIter.buffer();
        this.hasNext = this.moveToNext();
    }

    public boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.ewahIter.hasNext()) {
                return false;
            }
            this.setRunningLengthWord(this.ewahIter.next());
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position++;
        } else {
            long t = this.word & -this.word;
            answer = this.literalPosition + Long.bitCount(t - 1L);
            this.word ^= t;
        }
        this.hasNext = this.moveToNext();
        return answer;
    }

    private void setRunningLengthWord(RunningLengthWord rlw) {
        this.runningLength = Math.min(this.sizeInBits, 64 * (int)rlw.getRunningLength() + this.position);
        if (rlw.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.ewahIter.literalWords();
        this.wordLength = this.wordPosition + rlw.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0L && this.wordPosition < this.wordLength) {
            int usedBitsInLast;
            this.word = this.buffer.getWord(this.wordPosition++) ^ 0xFFFFFFFFFFFFFFFFL;
            if (this.wordPosition == this.wordLength && !this.ewahIter.hasNext() && (usedBitsInLast = this.sizeInBits % 64) > 0) {
                this.word &= -1L >>> 64 - usedBitsInLast;
            }
            this.literalPosition = this.position;
            this.position += 64;
        }
        return this.word != 0L;
    }
}

