/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain;

import com.github.zafarkhaja.semver.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import pl.allegro.tech.build.axion.release.domain.VersionFactory;
import pl.allegro.tech.build.axion.release.domain.scm.TaggedCommits;
import pl.allegro.tech.build.axion.release.domain.scm.TagsOnCommit;

class VersionSorter {
    VersionSorter() {
    }

    Result pickTaggedCommit(TaggedCommits taggedCommits, boolean ignoreNextVersionTags, boolean forceSnapshot, Pattern nextVersionTagPattern, VersionFactory versionFactory) {
        Version version;
        LinkedHashSet<Version> versions = new LinkedHashSet<Version>();
        LinkedHashMap<Version, Boolean> isVersionNextVersion = new LinkedHashMap<Version, Boolean>();
        LinkedHashMap<Version, TagsOnCommit> versionToCommit = new LinkedHashMap<Version, TagsOnCommit>();
        for (TagsOnCommit tagsEntry : taggedCommits.getCommits()) {
            List<String> tags = tagsEntry.getTags();
            boolean ignoreNextVersionOnHead = taggedCommits.isLatestCommit(tagsEntry.getCommitId()) && !tagsEntry.hasOnlyMatching(nextVersionTagPattern) && !forceSnapshot;
            for (String tag : tags) {
                boolean isNormalVersion;
                boolean isNextVersion = nextVersionTagPattern.matcher(tag).matches();
                if (isNextVersion && (ignoreNextVersionTags || ignoreNextVersionOnHead)) continue;
                Version version2 = versionFactory.versionFromTag(tag);
                boolean versionDidNotExist = versions.add(version2);
                boolean bl = isNormalVersion = !isNextVersion;
                if (versionDidNotExist || isNormalVersion) {
                    versionToCommit.put(version2, tagsEntry);
                }
                if (isVersionNextVersion.containsKey(version2)) {
                    isVersionNextVersion.put(version2, (Boolean)isVersionNextVersion.get(version2) != false && isNextVersion);
                    continue;
                }
                isVersionNextVersion.put(version2, isNextVersion);
            }
        }
        ArrayList versionList = new ArrayList(versions);
        Collections.sort(versionList, Collections.reverseOrder());
        Version version3 = version = versionList.isEmpty() ? versionFactory.initialVersion() : (Version)versionList.get(0);
        if (version == null) {
            version = versionFactory.initialVersion();
        }
        TagsOnCommit versionCommit = (TagsOnCommit)versionToCommit.get(version);
        return new Result(version, isVersionNextVersion.containsKey(version) && (Boolean)isVersionNextVersion.get(version) != false, versions.isEmpty(), versionCommit == null ? null : versionCommit.getCommitId());
    }

    static class Result {
        final Version version;
        final boolean isNextVersion;
        final boolean noTagsFound;
        final String commit;

        private Result(Version version, boolean isNextVersion, boolean noTagsFound, String commit) {
            this.version = version;
            this.isNextVersion = isNextVersion;
            this.noTagsFound = noTagsFound;
            this.commit = commit;
        }

        boolean isSameCommit(String otherCommitId) {
            return Objects.equals(this.commit, otherCommitId);
        }
    }
}

