/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import pl.allegro.tech.build.axion.release.domain.ScmState;
import pl.allegro.tech.build.axion.release.domain.VersionIncrementerContext;
import pl.allegro.tech.build.axion.release.domain.properties.NextVersionProperties;
import pl.allegro.tech.build.axion.release.domain.properties.TagProperties;
import pl.allegro.tech.build.axion.release.domain.properties.VersionProperties;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPosition;

public class VersionFactory {
    private final VersionProperties versionProperties;
    private final TagProperties tagProperties;
    private final NextVersionProperties nextVersionProperties;
    private final ScmPosition position;

    public VersionFactory(VersionProperties versionProperties, TagProperties tagProperties, NextVersionProperties nextVersionProperties, ScmPosition position) {
        this.tagProperties = tagProperties;
        this.nextVersionProperties = nextVersionProperties;
        this.versionProperties = versionProperties;
        this.position = position;
    }

    public Version versionFromTag(String tag) {
        String tagWithoutNextVersion = tag;
        if (Pattern.matches(".*" + this.nextVersionProperties.getSuffix() + "$", tag)) {
            tagWithoutNextVersion = (String)this.nextVersionProperties.getDeserializer().call(new Object[]{this.nextVersionProperties, this.position, tag});
        }
        try {
            return Version.valueOf((String)((String)this.tagProperties.getDeserialize().call(new Object[]{this.tagProperties, this.position, tagWithoutNextVersion})));
        }
        catch (ParseException parseException) {
            throw new TagParseException(this.tagProperties.getPrefix(), tagWithoutNextVersion, parseException);
        }
    }

    public Version initialVersion() {
        return Version.valueOf((String)((String)this.tagProperties.getInitialVersion().call(new Object[]{this.tagProperties, this.position})));
    }

    public FinalVersion createFinalVersion(ScmState scmState, Version version) {
        boolean hasUncommittedChanges = !this.versionProperties.isIgnoreUncommittedChanges() && scmState.hasUncommittedChanges();
        boolean hasCommittedChanges = !scmState.isOnReleaseTag();
        boolean hasChanges = hasCommittedChanges || hasUncommittedChanges;
        boolean forcesSameVersionAsCurrent = this.versionProperties.forceVersion() && this.versionProperties.getForcedVersion().equals(version.toString());
        boolean forceVersionShouldForceSnapshot = this.versionProperties.forceVersion() && !forcesSameVersionAsCurrent;
        boolean isSnapshot = forceVersionShouldForceSnapshot || this.versionProperties.isForceSnapshot() || hasChanges || scmState.isOnNextVersionTag() || scmState.isNoReleaseTagsFound();
        boolean proposedVersionIsAlreadySnapshot = scmState.isOnNextVersionTag() || scmState.isNoReleaseTagsFound();
        boolean incrementVersion = (this.versionProperties.isForceSnapshot() || hasChanges) && !proposedVersionIsAlreadySnapshot;
        Version finalVersion = version;
        if (StringGroovyMethods.asBoolean((CharSequence)this.versionProperties.getForcedVersion())) {
            finalVersion = Version.valueOf((String)this.versionProperties.getForcedVersion());
        } else if (incrementVersion) {
            finalVersion = (Version)this.versionProperties.getVersionIncrementer().call((Object)new VersionIncrementerContext(version, this.position));
        }
        return new FinalVersion(finalVersion, isSnapshot);
    }

    public static class TagParseException
    extends RuntimeException {
        public TagParseException(String prefix, String parsedText, ParseException cause) {
            super("Failed to parse version: " + parsedText + " that matched configured prefix: " + prefix + ". There can be no tags that match the prefix but contain non-SemVer string after the prefix. Detailed message: " + cause.toString());
        }
    }

    static class FinalVersion {
        final Version version;
        final boolean snapshot;

        private FinalVersion(Version version, boolean snapshot) {
            this.version = version;
            this.snapshot = snapshot;
        }
    }
}

