/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Box;
import org.zkoss.zul.impl.XulElement;

public class Splitter
extends XulElement {
    private String _collapse = "none";
    private boolean _open = true;

    public boolean isVertical() {
        Box box = (Box)this.getParent();
        return box == null || box.isVertical();
    }

    public boolean isHorizontal() {
        Box box = (Box)this.getParent();
        return box != null && box.isHorizontal();
    }

    public String getOrient() {
        Box box = (Box)this.getParent();
        return box != null ? box.getOrient() : "vertical";
    }

    public String getCollapse() {
        return this._collapse;
    }

    public void setCollapse(String collapse) throws WrongValueException {
        if (collapse == null || collapse.length() == 0) {
            collapse = "none";
        } else if (!("none".equals(collapse) || "before".equals(collapse) || "after".equals(collapse))) {
            throw new WrongValueException("Unknown collpase: " + collapse);
        }
        if (!Objects.equals((Object)this._collapse, (Object)collapse)) {
            this._collapse = collapse;
            this.smartUpdate("collapse", collapse);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", open);
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Box)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    protected boolean isChildable() {
        return false;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!this._open) {
            renderer.render("open", false);
        }
        if (!"none".equals(this._collapse)) {
            this.render(renderer, "collapse", this._collapse);
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-splitter";
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Splitter.addClientEvent(Splitter.class, (String)"onOpen", (int)1);
    }
}

