/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listfoot;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.ListgroupRendererExt;
import org.zkoss.zul.Listgroupfoot;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.Paging;
import org.zkoss.zul.event.GroupsDataEvent;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.ext.GroupingInfo;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.DataLoader;
import org.zkoss.zul.impl.GroupsListModel;
import org.zkoss.zul.impl.LoadStatus;
import org.zkoss.zul.impl.Utils;

public class ListboxDataLoader
implements DataLoader,
Cropper {
    private Listbox _listbox;
    private int INVALIDATE_THRESHOLD = -1;
    private static final ListitemRenderer _defRend = new ListitemRenderer(){

        public void render(Listitem item, final Object data, final int index) {
            Template tm2;
            final Listbox listbox = (Listbox)item.getParent();
            Template tm = listbox.getTemplate("model");
            GroupingInfo info = null;
            if (item instanceof Listgroup) {
                tm2 = listbox.getTemplate("model:group");
                if (tm2 != null) {
                    tm = tm2;
                }
                if (listbox.getModel() instanceof GroupsListModel) {
                    GroupsListModel gmodel = (GroupsListModel)listbox.getModel();
                    info = gmodel.getDataInfo(index);
                }
            } else if (item instanceof Listgroupfoot && (tm2 = listbox.getTemplate("model:groupfoot")) != null) {
                tm = tm2;
            }
            if (tm == null) {
                item.setLabel(Objects.toString((Object)data));
                item.setValue(data);
            } else {
                final GroupingInfo groupingInfo = info;
                Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])tm.create((Component)listbox, (Component)item, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return data;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return this.getCurrent();
                                }

                                public int getIndex() {
                                    return index;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    return listbox.getModel().getSize();
                                }

                                public Object getCurrent() {
                                    return data;
                                }

                                public boolean isFirst() {
                                    return this.getCount() == 1;
                                }

                                public boolean isLast() {
                                    return this.getIndex() + 1 == this.getEnd();
                                }

                                public Integer getStep() {
                                    return null;
                                }

                                public int getCount() {
                                    return this.getIndex() + 1;
                                }
                            };
                        }
                        if ("groupingInfo".equals(name)) {
                            return groupingInfo;
                        }
                        return null;
                    }
                }, null));
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one item, not " + items.length);
                }
                Listitem nli = (Listitem)items[0];
                if (nli instanceof Listgroup && item instanceof Listgroup) {
                    ((Listgroup)nli).setOpen(((Listgroup)item).isOpen());
                }
                if (nli.getValue() == null) {
                    nli.setValue(data);
                }
                item.setAttribute("org.zkoss.zul.model.renderAs", (Object)nli);
                item.detach();
            }
        }
    };

    @Override
    public void init(Component owner, int offset, int limit) {
        this._listbox = (Listbox)owner;
    }

    @Override
    public void reset() {
    }

    @Override
    public final Component getOwner() {
        return this._listbox;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public int getLimit() {
        return this._listbox.getRows() > 0 ? this._listbox.getRows() + 5 : 50;
    }

    @Override
    public int getTotalSize() {
        ListModel model = this._listbox.getModel();
        return model != null ? model.getSize() : this._listbox.getVisibleItemCount();
    }

    @Override
    public void doGroupsDataChange(GroupsDataEvent event) {
        if (event.getType() == 10) {
            Listbox listbox = (Listbox)this.getOwner();
            GroupsListModel groupsListModel = (GroupsListModel)listbox.getModel();
            int offset = groupsListModel.getGroupOffset(event.getGroupIndex());
            ((Listgroup)listbox.getItems().get(offset)).setOpen(groupsListModel.getDataInfo(offset).isOpen());
        }
    }

    @Override
    public void doListDataChange(ListDataEvent event) {
        if (this.INVALIDATE_THRESHOLD == -1) {
            this.INVALIDATE_THRESHOLD = Utils.getIntAttribute(this.getOwner(), "org.zkoss.zul.invalidateThreshold", 10, true);
        }
        ListModel _model = this._listbox.getModel();
        int newsz = _model.getSize();
        int oldsz = this._listbox.getItemCount();
        int min = event.getIndex0();
        int max = event.getIndex1();
        switch (event.getType()) {
            case 1: {
                Listitem next;
                int cnt = newsz - oldsz;
                if (cnt < 0) {
                    throw new UiException("Adding causes a smaller list?");
                }
                if (cnt == 0) {
                    return;
                }
                if (!(oldsz > 0 && cnt <= this.INVALIDATE_THRESHOLD || this.inPagingMold())) {
                    this._listbox.invalidatePartial();
                }
                if (min < 0) {
                    min = max < 0 ? 0 : max - cnt + 1;
                }
                if (min > oldsz) {
                    min = oldsz;
                }
                ListitemRenderer renderer = null;
                Listitem listitem = next = min < oldsz ? this._listbox.getItemAtIndex(min) : null;
                while (--cnt >= 0) {
                    if (renderer == null) {
                        renderer = (ListitemRenderer)this.getRealRenderer();
                    }
                    this._listbox.insertBefore((Component)this.newUnloadedItem(renderer, min++), (Component)next);
                }
                break;
            }
            case 2: {
                int cnt = oldsz - newsz;
                if (cnt < 0) {
                    throw new UiException("Removal causes a larger list?");
                }
                if (cnt == 0) {
                    return;
                }
                if (min >= 0) {
                    max = min + cnt - 1;
                } else if (max < 0) {
                    max = cnt - 1;
                }
                if (max > oldsz - 1) {
                    max = oldsz - 1;
                }
                if (!(newsz > 0 && cnt <= this.INVALIDATE_THRESHOLD || this.inPagingMold())) {
                    this._listbox.shallUpdateScrollPos(true);
                    this._listbox.invalidatePartial();
                }
                Listitem comp = this._listbox.getItemAtIndex(max);
                while (--cnt >= 0) {
                    Component p = comp.getPreviousSibling();
                    comp.detach();
                    comp = p;
                }
                break;
            }
            default: {
                this.syncModel(min, max < 0 ? -1 : max - min + 1);
            }
        }
    }

    protected final Listitem newUnloadedItem(ListitemRenderer renderer, int index) {
        ListModel model = this._listbox.getModel();
        Listitem item = null;
        if (model instanceof GroupsListModel) {
            GroupsListModel gmodel = (GroupsListModel)model;
            GroupingInfo info = gmodel.getDataInfo(index);
            switch (info.getType()) {
                case 0: {
                    item = this.newListgroup(renderer);
                    ((Listgroup)item).setOpen(info.isOpen());
                    break;
                }
                case 1: {
                    item = this.newListgroupfoot(renderer);
                    break;
                }
                default: {
                    item = this.newListitem(renderer);
                    break;
                }
            }
        } else {
            item = this.newListitem(renderer);
        }
        ((LoadStatus)item.getExtraCtrl()).setLoaded(false);
        ((LoadStatus)item.getExtraCtrl()).setIndex(index);
        this.newUnloadedCell(renderer, item);
        return item;
    }

    private Listitem newListitem(ListitemRenderer renderer) {
        Listitem item = null;
        if (renderer instanceof ListitemRendererExt) {
            item = ((ListitemRendererExt)((Object)renderer)).newListitem(this._listbox);
        }
        if (item == null) {
            item = new Listitem();
            item.applyProperties();
        }
        return item;
    }

    private Listgroup newListgroup(ListitemRenderer renderer) {
        Listgroup group = null;
        if (renderer instanceof ListgroupRendererExt) {
            group = ((ListgroupRendererExt)((Object)renderer)).newListgroup(this._listbox);
        }
        if (group == null) {
            group = new Listgroup();
            group.applyProperties();
        }
        return group;
    }

    private Listgroupfoot newListgroupfoot(ListitemRenderer renderer) {
        Listgroupfoot groupfoot = null;
        if (renderer instanceof ListgroupRendererExt) {
            groupfoot = ((ListgroupRendererExt)((Object)renderer)).newListgroupfoot(this._listbox);
        }
        if (groupfoot == null) {
            groupfoot = new Listgroupfoot();
            groupfoot.applyProperties();
        }
        return groupfoot;
    }

    private Listcell newUnloadedCell(ListitemRenderer renderer, Listitem item) {
        Listcell cell = null;
        if (renderer instanceof ListitemRendererExt) {
            cell = ((ListitemRendererExt)((Object)renderer)).newListcell(item);
        }
        if (cell == null) {
            cell = new Listcell();
            cell.applyProperties();
        }
        cell.setParent((Component)item);
        return cell;
    }

    @Override
    public Object getRealRenderer() {
        ListitemRenderer renderer = this._listbox.getItemRenderer();
        return renderer != null ? renderer : _defRend;
    }

    @Override
    public void syncModel(int offset, int limit) {
        this._listbox.setAttribute("org.zkoss.zul.syncingModel", Boolean.TRUE);
        try {
            this.syncModel0(offset, limit);
        }
        finally {
            this._listbox.removeAttribute("org.zkoss.zul.syncingModel");
        }
    }

    private void syncModel0(int offset, int limit) {
        int min = offset;
        int max = offset + limit - 1;
        ListModel _model = this._listbox.getModel();
        int newsz = _model.getSize();
        int oldsz = this._listbox.getItemCount();
        Paginal _pgi = this._listbox.getPaginal();
        boolean inPaging = this.inPagingMold();
        boolean shallInvalidated = !(min >= 0 && min != 0 || max >= 0 && max < newsz && max < oldsz);
        int newcnt = newsz - oldsz;
        int atg = _pgi != null ? this._listbox.getActivePage() : 0;
        ListitemRenderer renderer = null;
        Component next = null;
        if (oldsz > 0) {
            if (min < 0) {
                min = 0;
            } else if (min > oldsz - 1) {
                min = oldsz - 1;
            }
            if (max < 0) {
                max = oldsz - 1;
            } else if (max > oldsz - 1) {
                max = oldsz - 1;
            }
            if (min > max) {
                int t = min;
                min = max;
                max = t;
            }
            int cnt = max - min + 1;
            if (_model instanceof GroupsListModel) {
                if ((shallInvalidated || (newcnt += cnt) > this.INVALIDATE_THRESHOLD) && !inPaging) {
                    this._listbox.invalidatePartial();
                }
                Listitem comp = this._listbox.getItemAtIndex(max);
                next = comp.getNextSibling();
                while (--cnt >= 0) {
                    Component p = comp.getPreviousSibling();
                    comp.detach();
                    comp = p;
                }
            } else {
                int addcnt = 0;
                Listitem item = this._listbox.getItemAtIndex(min);
                while (--cnt >= 0) {
                    next = item.getNextSibling();
                    if (cnt < -newcnt) {
                        item.detach();
                    } else if (item.isLoaded()) {
                        if (renderer == null) {
                            renderer = (ListitemRenderer)this.getRealRenderer();
                        }
                        if (_pgi != null && item.isSelected()) {
                            int index = item.getIndex();
                            item.detach();
                            Listitem newItem = this.newUnloadedItem(renderer, min);
                            this._listbox.insertBefore((Component)newItem, next);
                            this._listbox.addItemToSelection(newItem);
                        } else {
                            item.detach();
                            this._listbox.insertBefore((Component)this.newUnloadedItem(renderer, min), next);
                        }
                        ++addcnt;
                    }
                    ++min;
                    item = next;
                }
                if ((shallInvalidated || addcnt > this.INVALIDATE_THRESHOLD || addcnt + newcnt > this.INVALIDATE_THRESHOLD) && !this.inPagingMold()) {
                    this._listbox.invalidatePartial();
                }
            }
        } else {
            min = 0;
        }
        while (--newcnt >= 0) {
            if (renderer == null) {
                renderer = (ListitemRenderer)this.getRealRenderer();
            }
            this._listbox.insertBefore((Component)this.newUnloadedItem(renderer, min), next);
            ++min;
        }
        if (_pgi != null) {
            if (atg >= _pgi.getPageCount()) {
                atg = _pgi.getPageCount() - 1;
            }
            _pgi.setActivePage(atg);
            if (_pgi.getTotalSize() != newsz) {
                _pgi.setTotalSize(newsz);
            }
        }
    }

    protected boolean inPagingMold() {
        return "paging".equals(this._listbox.getMold());
    }

    protected boolean inSelectMold() {
        return "select".equals(this._listbox.getMold());
    }

    @Override
    public void updateModelInfo() {
    }

    @Override
    public void setLoadAll(boolean b) {
    }

    public boolean isCropper() {
        return this._listbox != null && this.inPagingMold() && this._listbox.getPageSize() <= this.getTotalSize();
    }

    public final Set<? extends Component> getAvailableAtClient() {
        return this.getAvailableAtClient(false);
    }

    protected Set<? extends Component> getAvailableAtClient(boolean itemOnly) {
        if (!this.isCropper()) {
            return null;
        }
        Paginal pgi = this._listbox.getPaginal();
        int pgsz = pgi.getPageSize();
        int ofs = pgi.getActivePage() * pgsz;
        return this.getAvailableAtClient(ofs, pgsz, itemOnly);
    }

    protected Set<? extends Component> getAvailableAtClient(int offset, int limit, boolean itemOnly) {
        if (!this.isCropper()) {
            return null;
        }
        LinkedHashSet<Object> avail = new LinkedHashSet<Object>(32);
        if (!itemOnly) {
            Frozen frozen;
            Paging paging;
            avail.addAll(this._listbox.getHeads());
            Listfoot listfoot = this._listbox.getListfoot();
            if (listfoot != null) {
                avail.add((Object)listfoot);
            }
            if ((paging = this._listbox.getPagingChild()) != null) {
                avail.add(paging);
            }
            if ((frozen = this._listbox.getFrozen()) != null) {
                avail.add((Object)frozen);
            }
        }
        int pgsz = limit;
        int ofs = offset;
        if (this._listbox.getItemCount() > 0) {
            Component item = (Component)this._listbox.getItems().get(0);
            while (item != null && pgsz != 0) {
                Listgroup g;
                if (item.isVisible() && item instanceof Listitem && --ofs < 0) {
                    --pgsz;
                    avail.add(item);
                }
                if (item instanceof Listgroup && !(g = (Listgroup)item).isOpen()) {
                    int len = g.getItemCount();
                    for (int j = 0; j < len; ++j) {
                        item = item.getNextSibling();
                    }
                }
                if (item == null) continue;
                item = item.getNextSibling();
            }
        }
        return avail;
    }

    public Component getCropOwner() {
        return this._listbox;
    }
}

