/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ext.Sortable;

public class ListModelArray<E>
extends AbstractListModel<E>
implements Sortable<E>,
Serializable {
    private static final long serialVersionUID = 20070226L;
    protected Object[] _array;
    private Comparator<E> _sorting;
    private boolean _sortDir;

    public ListModelArray(E[] array, boolean live) {
        this._array = live ? array : ArraysX.duplicate((Object[])array);
    }

    public ListModelArray(E[] array) {
        this._array = ArraysX.duplicate((Object[])array);
    }

    public ListModelArray(int size) {
        this._array = new Object[size];
    }

    public ListModelArray(List<? extends E> list) {
        this._array = list.toArray(new Object[list.size()]);
    }

    public E get(int index) {
        return this.getElementAt(index);
    }

    public void set(int index, E value) {
        this._array[index] = value;
        this.fireEvent(0, index, index);
    }

    public Object[] getInnerArray() {
        return this._array;
    }

    public int indexOf(Object elm) {
        for (int j = 0; j < this._array.length; ++j) {
            if (!Objects.equals((Object)elm, (Object)this._array[j])) continue;
            return j;
        }
        return -1;
    }

    public boolean notifyChange(E element) {
        int i = this.indexOf(element);
        if (i >= 0) {
            this.fireEvent(0, i, i);
            return true;
        }
        return false;
    }

    @Override
    public int getSize() {
        return this._array.length;
    }

    @Override
    public E getElementAt(int j) {
        return (E)this._array[j];
    }

    @Override
    public void sort(Comparator<E> cmpr, boolean ascending) {
        this._sorting = cmpr;
        this._sortDir = ascending;
        Arrays.sort(this._array, cmpr);
        this.fireEvent(3, -1, -1);
    }

    @Override
    public String getSortDirection(Comparator<E> cmpr) {
        if (Objects.equals(this._sorting, cmpr)) {
            return this._sortDir ? "ascending" : "descending";
        }
        return "natural";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ListModelArray) {
            return Arrays.equals(this._array, ((ListModelArray)o)._array);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this._array);
    }

    public String toString() {
        return Objects.toString((Object)this._array);
    }

    @Override
    public Object clone() {
        ListModelArray clone = (ListModelArray)super.clone();
        if (this._array != null) {
            clone._array = ArraysX.duplicate((Object[])this._array);
        }
        return clone;
    }

    @Override
    protected void fireSelectionEvent(E e) {
        this.fireEvent(4, this.indexOf(e), -1);
    }

    public void addSelection(E obj) {
        this.addToSelection(obj);
    }

    public void removeSelection(Object obj) {
        this.removeFromSelection(obj);
    }
}

