/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SortEvent;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.ArrayComparator;
import org.zkoss.zul.FieldComparator;
import org.zkoss.zul.GroupComparator;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemComparator;
import org.zkoss.zul.ext.GroupsSortableModel;
import org.zkoss.zul.ext.Sortable;
import org.zkoss.zul.impl.HeaderElement;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.mesg.MZul;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Listheader
extends HeaderElement {
    private static final long serialVersionUID = 20080218L;
    private String _sortDir = "natural";
    private transient Comparator _sortAsc;
    private transient Comparator _sortDsc;
    private String _sortAscNm = "none";
    private String _sortDscNm = "none";
    private Object _value;
    private int _maxlength;
    private boolean _ignoreSort = false;
    private boolean _isCustomAscComparator = false;
    private boolean _isCustomDscComparator = false;

    public Listheader() {
    }

    public Listheader(String label) {
        super(label);
    }

    public Listheader(String label, String src) {
        super(label, src);
    }

    public Listheader(String label, String src, String width) {
        super(label, src);
        this.setWidth(width);
    }

    public Listbox getListbox() {
        Component comp = this.getParent();
        return comp != null ? (Listbox)comp.getParent() : null;
    }

    public <T> T getValue() {
        return (T)this._value;
    }

    public <T> void setValue(T value) {
        this._value = value;
    }

    public String getSortDirection() {
        return this._sortDir;
    }

    public void setSortDirection(String sortDir) throws WrongValueException {
        if (sortDir == null || !"ascending".equals(sortDir) && !"descending".equals(sortDir) && !"natural".equals(sortDir)) {
            throw new WrongValueException("Unknown sort direction: " + sortDir);
        }
        if (!Objects.equals((Object)this._sortDir, (Object)sortDir)) {
            Listbox listbox;
            this._sortDir = sortDir;
            if (!"natural".equals(sortDir) && !this._ignoreSort && (listbox = this.getListbox()) != null && listbox.isAutosort()) {
                this.doSort("ascending".equals(sortDir));
            }
            this.smartUpdate("sortDirection", this._sortDir);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSort(String type) {
        if (type == null) {
            return;
        }
        if (type.startsWith("client")) {
            try {
                this.setSortAscending(type);
                this.setSortDescending(type);
                return;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        } else if ("auto".equals(type)) {
            if (this.getSortAscending() == null) {
                this.setSortAscending(new ListitemComparator(this, true, true));
            }
            if (this.getSortDescending() != null) return;
            this.setSortDescending(new ListitemComparator(this, false, true));
            return;
        } else if (!Strings.isBlank((String)type) && type.startsWith("auto")) {
            char cc;
            int j = type.indexOf(40);
            int k = type.lastIndexOf(41);
            if (j < 0 || k < 0) throw new UiException("Unknown sort type: " + type);
            String name = type.substring(j + 1, k);
            int index = -1;
            if (name.length() > 0 && (cc = name.charAt(0)) >= '0' && cc <= '9' && (index = Integer.parseInt(name)) < 0) {
                throw new IllegalArgumentException("Nonnegative number is required: " + name);
            }
            if (this.getSortAscending() == null || !this._isCustomAscComparator) {
                if (index < 0) {
                    this.setSortAscending(new FieldComparator(name, true));
                } else {
                    this.setSortAscending(new ArrayComparator(index, true));
                }
                this._isCustomAscComparator = false;
            }
            if (this.getSortDescending() != null && this._isCustomDscComparator) return;
            if (index < 0) {
                this.setSortDescending(new FieldComparator(name, false));
            } else {
                this.setSortDescending(new ArrayComparator(index, false));
            }
            this._isCustomDscComparator = false;
            return;
        } else {
            if (!"none".equals(type)) return;
            this.setSortAscending((Comparator)null);
            this.setSortDescending((Comparator)null);
        }
    }

    public Comparator getSortAscending() {
        return this._sortAsc;
    }

    public void setSortAscending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortAsc, (Object)sorter)) {
            String nm;
            this._sortAsc = sorter;
            this._isCustomAscComparator = this._sortAsc != null;
            String string = nm = this._isCustomAscComparator ? "fromServer" : "none";
            if (!this._sortAscNm.equals(nm)) {
                this._sortAscNm = nm;
                this.smartUpdate("sortAscending", this._sortAscNm);
            }
        }
    }

    public void setSortAscending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortAscNm.equals(clsnm)) {
            this._sortAscNm = clsnm;
            this.smartUpdate("sortAscending", clsnm);
        } else {
            this.setSortAscending(this.toComparator(clsnm));
        }
    }

    public Comparator getSortDescending() {
        return this._sortDsc;
    }

    public void setSortDescending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortDsc, (Object)sorter)) {
            String nm;
            this._sortDsc = sorter;
            this._isCustomDscComparator = this._sortDsc != null;
            String string = nm = this._isCustomDscComparator ? "fromServer" : "none";
            if (!this._sortDscNm.equals(nm)) {
                this._sortDscNm = nm;
                this.smartUpdate("sortDescending", this._sortDscNm);
            }
        }
    }

    public void setSortDescending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortDscNm.equals(clsnm)) {
            this._sortDscNm = clsnm;
            this.smartUpdate("sortDescending", clsnm);
        } else {
            this.setSortDescending(this.toComparator(clsnm));
        }
    }

    private Comparator toComparator(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls;
        if (clsnm == null || clsnm.length() == 0) {
            return null;
        }
        Page page = this.getPage();
        Class clazz = cls = page != null ? page.resolveClass(clsnm) : Classes.forNameByThread((String)clsnm);
        if (cls == null) {
            throw new ClassNotFoundException(clsnm);
        }
        if (!Comparator.class.isAssignableFrom(cls)) {
            throw new UiException("Comparator must be implemented: " + clsnm);
        }
        return (Comparator)cls.newInstance();
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.smartUpdate("maxlength", maxlength);
        }
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    public boolean sort(boolean ascending) {
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        return this.doSort(ascending);
    }

    public boolean sort(boolean ascending, boolean force) {
        if (force) {
            this.setSortDirection("natural");
        }
        return this.sort(ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doSort(boolean ascending) {
        Comparator cmpr;
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Listbox box = this.getListbox();
        if (box == null) {
            return false;
        }
        Scopes.beforeInterpret((Scope)this);
        try {
            int activePg;
            ListModel model = box.getModel();
            boolean isPagingMold = box.inPagingMold();
            int n = activePg = isPagingMold ? box.getPaginal().getActivePage() : 0;
            if (model != null) {
                if (model instanceof GroupsSortableModel) {
                    this.sortGroupsModel(box, (GroupsSortableModel)((Object)model), cmpr, ascending);
                } else {
                    if (!(model instanceof Sortable)) {
                        throw new UiException(GroupsSortableModel.class + " or " + Sortable.class + " must be implemented in " + model.getClass().getName());
                    }
                    this.sortListModel((Sortable)((Object)model), cmpr, ascending);
                }
            } else {
                Listheader.sort0(box, cmpr);
            }
            if (isPagingMold) {
                box.getPaginal().setActivePage(activePg);
            }
        }
        finally {
            Scopes.afterInterpret();
        }
        this._ignoreSort = true;
        Iterator it = box.getListhead().getChildren().iterator();
        while (it.hasNext()) {
            Listheader hd;
            hd.setSortDirection((hd = (Listheader)((Object)it.next())) != this ? "natural" : (ascending ? "ascending" : "descending"));
        }
        this._ignoreSort = false;
        box.invalidate();
        return true;
    }

    private void fixDirection(Listbox listbox, boolean ascending) {
        this._ignoreSort = true;
        Iterator it = listbox.getListhead().getChildren().iterator();
        while (it.hasNext()) {
            Listheader hd;
            hd.setSortDirection((hd = (Listheader)((Object)it.next())) != this ? "natural" : (ascending ? "ascending" : "descending"));
        }
        this._ignoreSort = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean group(boolean ascending) {
        Comparator cmpr;
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Listbox listbox = this.getListbox();
        if (listbox == null) {
            return false;
        }
        Scopes.beforeInterpret((Scope)this);
        try {
            ListModel model = listbox.getModel();
            int index = listbox.getListhead().getChildren().indexOf((Object)this);
            if (model != null) {
                if (!(model instanceof GroupsSortableModel)) {
                    throw new UiException(GroupsSortableModel.class + " must be implemented in " + model.getClass().getName());
                }
                this.groupGroupsModel((GroupsSortableModel)((Object)model), cmpr, ascending, index);
            } else {
                List<Listitem> items = listbox.getItems();
                if (items.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                if (listbox.hasGroup()) {
                    for (Listgroup group : new ArrayList<Listgroup>(listbox.getGroups())) {
                        group.detach();
                    }
                }
                Comparator cmprx = cmpr instanceof GroupComparator ? new GroupToComparator((GroupComparator)cmpr) : cmpr;
                LinkedList<Listitem> children = new LinkedList<Listitem>(items);
                items.clear();
                Listheader.sortCollection(children, cmprx);
                Listitem previous = null;
                for (Listitem item : children) {
                    if (previous == null || Listheader.compare(cmprx, previous, (Object)item) != 0) {
                        Listgroup group;
                        List cells = item.getChildren();
                        if (cells.size() < index) {
                            throw new IndexOutOfBoundsException("Index: " + index + " but size: " + cells.size());
                        }
                        Listcell cell = (Listcell)((Object)cells.get(index));
                        if (cell.getLabel() != null) {
                            group = new Listgroup(cell.getLabel());
                        } else {
                            Component cc = cell.getFirstChild();
                            if (cc instanceof Label) {
                                String val = ((Label)cc).getValue();
                                group = new Listgroup(val);
                            } else {
                                group = new Listgroup(Messages.get((int)MZul.GRID_OTHER));
                            }
                        }
                        listbox.appendChild((Component)group);
                    }
                    listbox.appendChild((Component)item);
                    previous = item;
                }
                if (cmprx != cmpr) {
                    Listheader.sort0(listbox, cmpr);
                }
            }
        }
        finally {
            Scopes.afterInterpret();
        }
        this.fixDirection(listbox, ascending);
        listbox.invalidate();
        return true;
    }

    private void groupGroupsModel(GroupsSortableModel model, Comparator cmpr, boolean ascending, int index) {
        model.group(cmpr, ascending, index);
    }

    private static void sortCollection(List<Listitem> comps, Comparator cmpr) {
        Collections.sort(comps, cmpr);
    }

    private static int compare(Comparator cmpr, Object a, Object b) {
        return cmpr.compare(a, b);
    }

    private void sortGroupsModel(Listbox box, GroupsSortableModel model, Comparator cmpr, boolean ascending) {
        model.sort(cmpr, ascending, box.getListhead().getChildren().indexOf((Object)this));
    }

    private void sortListModel(Sortable model, Comparator cmpr, boolean ascending) {
        model.sort(cmpr, ascending);
    }

    private static void sort0(Listbox box, Comparator cmpr) {
        if (box.hasGroup()) {
            for (Listgroup g : box.getGroups()) {
                int index = g.getIndex() + 1;
                Components.sort(box.getItems(), (int)index, (int)(index + g.getItemCount()), (Comparator)cmpr);
            }
        } else {
            Components.sort(box.getItems(), (Comparator)cmpr);
        }
    }

    public void onSort(SortEvent event) {
        this.sort(event.isAscending());
    }

    public void onSort() {
        String dir = this.getSortDirection();
        if ("ascending".equals(dir)) {
            this.sort(false);
        } else if ("descending".equals(dir)) {
            this.sort(true);
        } else if (!this.sort(true)) {
            this.sort(false);
        }
    }

    public void onGroupLater(SortEvent event) {
        this.group(event.isAscending());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungroup(boolean ascending) {
        Comparator cmpr;
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr != null) {
            Listbox listbox = this.getListbox();
            if (listbox.getModel() == null) {
                Scopes.beforeInterpret((Scope)this);
                try {
                    List<Listitem> items = listbox.getItems();
                    if (listbox.hasGroup()) {
                        for (Listgroup group : new ArrayList<Listgroup>(listbox.getGroups())) {
                            group.detach();
                        }
                    }
                    Comparator cmprx = cmpr instanceof GroupComparator ? new GroupToComparator((GroupComparator)cmpr) : cmpr;
                    LinkedList<Listitem> children = new LinkedList<Listitem>(items);
                    items.clear();
                    Listheader.sortCollection(children, cmprx);
                    for (Component component : children) {
                        listbox.appendChild(component);
                    }
                }
                finally {
                    Scopes.afterInterpret();
                }
            }
            this.fixDirection(listbox, ascending);
            listbox.invalidate();
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-listheader" : this._zclass;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Listhead)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSort")) {
            SortEvent evt = SortEvent.getSortEvent((AuRequest)request);
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onGroup")) {
            Map data = request.getData();
            boolean ascending = AuRequests.getBoolean((Map)data, (String)"");
            Events.postEvent((Event)new SortEvent(cmd, (Component)this, ascending));
            Events.postEvent((int)-1000, (Event)new SortEvent("onGroupLater", (Component)this, ascending));
        } else if (cmd.equals("onUngroup")) {
            Map data = request.getData();
            boolean ascending = AuRequests.getBoolean((Map)data, (String)"");
            this.ungroup(ascending);
            Events.postEvent((Event)new SortEvent(cmd, request.getComponent(), ascending));
        } else {
            super.service(request, everError);
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"none".equals(this._sortDscNm)) {
            this.render(renderer, "sortDescending", this._sortDscNm);
        }
        if (!"none".equals(this._sortAscNm)) {
            this.render(renderer, "sortAscending", this._sortAscNm);
        }
        if (!"natural".equals(this._sortDir)) {
            this.render(renderer, "sortDirection", this._sortDir);
        }
        if (this._maxlength > 0) {
            renderer.render("maxlength", this._maxlength);
        }
        Utils.renderCrawlableText(this.getLabel());
    }

    @Override
    public Object clone() {
        Listheader clone = (Listheader)((Object)super.clone());
        clone.fixClone();
        return clone;
    }

    private void fixClone() {
        ListitemComparator c;
        if (this._sortAsc instanceof ListitemComparator && (c = (ListitemComparator)this._sortAsc).getListheader() == this && c.isAscending()) {
            this._sortAsc = new ListitemComparator(this, true, c.shallIgnoreCase());
        }
        if (this._sortDsc instanceof ListitemComparator && (c = (ListitemComparator)this._sortDsc).getListheader() == this && !c.isAscending()) {
            this._sortDsc = new ListitemComparator(this, false, c.shallIgnoreCase());
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        ListitemComparator c;
        s.defaultWriteObject();
        boolean written = false;
        if (this._sortAsc instanceof ListitemComparator && (c = (ListitemComparator)this._sortAsc).getListheader() == this && c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            s.writeBoolean(c.byValue());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortAsc);
        }
        written = false;
        if (this._sortDsc instanceof ListitemComparator && (c = (ListitemComparator)this._sortDsc).getListheader() == this && !c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            s.writeBoolean(c.byValue());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortDsc);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        boolean byval;
        boolean igcs;
        s.defaultReadObject();
        boolean b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            byval = s.readBoolean();
            this._sortAsc = new ListitemComparator(this, true, igcs, byval);
        } else {
            this._sortAsc = (Comparator)s.readObject();
        }
        b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            byval = s.readBoolean();
            this._sortDsc = new ListitemComparator(this, false, igcs, byval);
        } else {
            this._sortDsc = (Comparator)s.readObject();
        }
    }

    protected void updateByClient(String name, Object value) {
        if ("visible".equals(name)) {
            this.setVisibleDirectly((Boolean)value);
        } else {
            super.updateByClient(name, value);
        }
    }

    static {
        Listheader.addClientEvent(Listheader.class, (String)"onSort", (int)8192);
        Listheader.addClientEvent(Listheader.class, (String)"onGroup", (int)8192);
        Listheader.addClientEvent(Listheader.class, (String)"onUngroup", (int)8192);
    }

    private static class GroupToComparator
    implements Comparator {
        private final GroupComparator _gcmpr;

        private GroupToComparator(GroupComparator gcmpr) {
            this._gcmpr = gcmpr;
        }

        public int compare(Object o1, Object o2) {
            return this._gcmpr.compareGroup(o1, o2);
        }
    }
}

