/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.MutableInteger;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Radio;
import org.zkoss.zul.RadioRenderer;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.XulElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Radiogroup
extends XulElement {
    private static final Logger log = LoggerFactory.getLogger(Radiogroup.class);
    private static final String ZUL_RADIOGROUP_ON_INITRENDER = "zul.Radiogroup.ON_INITRENDER";
    private String _orient = "horizontal";
    private String _name = this.genGroupName();
    private List<Radio> _externs;
    private int _jsel = -1;
    private ListModel<?> _model;
    private RadioRenderer<?> _renderer;
    private transient ListDataListener _dataListener;
    private static final RadioRenderer _defRend;

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public List<Radio> getItems() {
        ArrayList<Radio> items = new ArrayList<Radio>();
        Radiogroup.getItems0((Component)this, items);
        if (this._externs != null) {
            for (Radio radio : this._externs) {
                if (this.isRedudant(radio)) continue;
                items.add(radio);
            }
        }
        return items;
    }

    private static void getItems0(Component comp, List<Radio> items) {
        for (Component child : comp.getChildren()) {
            if (child instanceof Radio) {
                items.add((Radio)child);
                continue;
            }
            if (child instanceof Radiogroup) continue;
            Radiogroup.getItems0(child, items);
        }
    }

    public Radio getItemAtIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        MutableInteger cur = new MutableInteger(0);
        Radio radio = Radiogroup.getAt((Component)this, cur, index);
        if (radio != null) {
            return radio;
        }
        if (this._externs != null) {
            for (Radio r : this._externs) {
                if (this.isRedudant(r) || cur.value++ != index) continue;
                return r;
            }
        }
        throw new IndexOutOfBoundsException(index + " out of 0.." + (cur.value - 1));
    }

    private static Radio getAt(Component comp, MutableInteger cur, int index) {
        for (Component child : comp.getChildren()) {
            Radio r;
            if (child instanceof Radio) {
                if (cur.value++ != index) continue;
                return (Radio)child;
            }
            if (child instanceof Radiogroup || (r = Radiogroup.getAt(child, cur, index)) == null) continue;
            return r;
        }
        return null;
    }

    private boolean isRedudant(Radio radio) {
        Radio p = radio;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Radiogroup)) continue;
            return p == this;
        }
        return false;
    }

    public int getItemCount() {
        int sum = Radiogroup.countItems((Component)this);
        if (this._externs != null) {
            for (Radio radio : this._externs) {
                if (this.isRedudant(radio)) continue;
                ++sum;
            }
        }
        return sum;
    }

    private static int countItems(Component comp) {
        int sum = 0;
        for (Component child : comp.getChildren()) {
            if (child instanceof Radio) {
                ++sum;
                continue;
            }
            if (child instanceof Radiogroup) continue;
            sum += Radiogroup.countItems(child);
        }
        return sum;
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public void setSelectedIndex(int jsel) {
        if (jsel < 0) {
            jsel = -1;
        }
        if (this._jsel != jsel) {
            if (jsel < 0) {
                Radio r = this.getSelectedItem();
                if (r != null) {
                    r.setSelected(false);
                }
            } else {
                this.getItemAtIndex(jsel).setSelected(true);
            }
        }
    }

    public Radio getSelectedItem() {
        return this._jsel >= 0 ? this.getItemAtIndex(this._jsel) : null;
    }

    public void setSelectedItem(Radio item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            if (item.getRadiogroup() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            item.setSelected(true);
        }
    }

    public Radio appendItem(String label, String value) {
        Radio item = new Radio();
        item.setLabel(label);
        item.setValue(value);
        item.setParent((Component)this);
        return item;
    }

    public Radio removeItemAt(int index) {
        Component p;
        Radio item = this.getItemAtIndex(index);
        if (item != null && !this.removeExternal(item) && (p = item.getParent()) != null) {
            p.removeChild((Component)item);
        }
        return item;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    void fixOnAdd(Radio child) {
        if (this._jsel >= 0 && child.isSelected()) {
            child.setSelected(false);
        } else {
            this.fixSelectedIndex();
        }
    }

    void fixOnRemove(Radio child) {
        if (child.isSelected()) {
            this._jsel = -1;
        } else if (this._jsel > 0) {
            this.fixSelectedIndex();
        }
    }

    void fixSelectedIndex() {
        MutableInteger cur = new MutableInteger(0);
        this._jsel = Radiogroup.fixSelIndex((Component)this, cur);
        if (this._jsel < 0 && this._externs != null) {
            for (Radio radio : this._externs) {
                if (this.isRedudant(radio)) continue;
                if (radio.isSelected()) {
                    this._jsel = cur.value;
                    break;
                }
                ++cur.value;
            }
        }
    }

    private static int fixSelIndex(Component comp, MutableInteger cur) {
        for (Component child : comp.getChildren()) {
            int jsel;
            if (child instanceof Radio) {
                if (((Radio)child).isSelected()) {
                    return cur.value;
                }
                ++cur.value;
                continue;
            }
            if (child instanceof Radiogroup || (jsel = Radiogroup.fixSelIndex(child, cur)) < 0) continue;
            return jsel;
        }
        return -1;
    }

    void addExternal(Radio radio) {
        if (this._externs == null) {
            this._externs = new LinkedList<Radio>();
        }
        this._externs.add(radio);
        if (!this.isRedudant(radio)) {
            this.fixOnAdd(radio);
        }
    }

    boolean removeExternal(Radio radio) {
        if (this._externs != null && this._externs.remove((Object)radio)) {
            if (!this.isRedudant(radio)) {
                this.fixOnRemove(radio);
            }
            return true;
        }
        return false;
    }

    private String genGroupName() {
        return Strings.encode((StringBuffer)new StringBuffer(16).append("_pg"), (int)System.identityHashCode((Object)this)).toString();
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._name != null) {
            this.render(renderer, "name", this._name);
        }
        if (!"horizontal".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
    }

    public <T> ListModel<T> getModel() {
        return this._model;
    }

    public void setModel(ListModel<?> model) {
        if (model != null) {
            if (!(model instanceof Selectable)) {
                throw new UiException(model.getClass() + " must implement " + Selectable.class);
            }
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                } else if (!this.getChildren().isEmpty()) {
                    this.getChildren().clear();
                }
                this._model = model;
                this.initDataListener();
            }
            this.postOnInitRender(null);
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            if (!this.getChildren().isEmpty()) {
                this.getChildren().clear();
            }
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    switch (event.getType()) {
                        case 4: {
                            Radiogroup.this.doSelectionChanged();
                            return;
                        }
                        case 6: {
                            return;
                        }
                    }
                    Radiogroup.this.postOnInitRender(null);
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    private void doSelectionChanged() {
        Selectable<Object> smodel = this.getSelectableModel();
        if (smodel.isSelectionEmpty()) {
            if (this._jsel >= 0) {
                this.setSelectedItem(null);
            }
            return;
        }
        if (this._jsel >= 0 && smodel.isSelected(this._model.getElementAt(this._jsel))) {
            return;
        }
        int j = 0;
        for (Radio item : this.getItems()) {
            if (!smodel.isSelected(this._model.getElementAt(j++))) continue;
            this.setSelectedItem(item);
            return;
        }
        this.setSelectedItem(null);
    }

    private Selectable<Object> getSelectableModel() {
        return (Selectable)((Object)this._model);
    }

    private void postOnInitRender(String idx) {
        if (this.getAttribute(ZUL_RADIOGROUP_ON_INITRENDER) == null) {
            this.setAttribute(ZUL_RADIOGROUP_ON_INITRENDER, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, (Object)idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitRender(Event data) {
        this.removeAttribute(ZUL_RADIOGROUP_ON_INITRENDER);
        Renderer renderer = new Renderer();
        ListModel<?> subset = this._model;
        try {
            if (!this.getChildren().isEmpty()) {
                this.getChildren().clear();
            }
            int pgsz = subset.getSize();
            int ofs = 0;
            for (int j = 0; j < pgsz; ++j) {
                Radio item = new Radio();
                item.applyProperties();
                item.setParent((Component)this);
                int index = j + ofs;
                Object value = subset.getElementAt(index);
                renderer.render(item, value, index);
                Object v = item.getAttribute("org.zkoss.zul.model.renderAs");
                if (v != null) {
                    item = (Radio)((Object)v);
                }
                if (!this.getSelectableModel().isSelected(value)) continue;
                this.setSelectedItem(item);
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onInitRenderLater", (Component)this, null);
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    void syncSelectionToModel() {
        if (this._model != null) {
            ArrayList selObjs = new ArrayList();
            if (this._jsel >= 0) {
                selObjs.add(this._model.getElementAt(this._jsel));
            }
            this.getSelectableModel().setSelection(selObjs);
        }
    }

    private <T> RadioRenderer<T> getRealRenderer() {
        return this._renderer != null ? this._renderer : _defRend;
    }

    public <T> RadioRenderer<T> getRadioRenderer() {
        return this._renderer;
    }

    public void setRadioRenderer(RadioRenderer<?> renderer) {
        this._renderer = renderer;
    }

    public void setRadioRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setRadioRenderer((RadioRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    @Override
    public Object clone() {
        Radiogroup clone = (Radiogroup)((Object)super.clone());
        Radiogroup.fixClone(clone);
        if (clone._model != null) {
            ListModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (ListModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone._dataListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private static void fixClone(Radiogroup clone) {
        if (clone._name.startsWith("_pg")) {
            clone._name = clone.genGroupName();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this._model != null) {
            this.initDataListener();
        }
    }

    static {
        Radiogroup.addClientEvent(Radiogroup.class, (String)"onCheck", (int)16385);
        _defRend = new RadioRenderer(){

            public void render(Radio item, final Object data, final int index) throws Exception {
                final Radiogroup cb = (Radiogroup)item.getParent();
                Template tm = cb.getTemplate("model");
                if (tm == null) {
                    item.setLabel(Objects.toString((Object)data));
                    item.setValue(data);
                } else {
                    Component[] items = tm.create(item.getParent(), (Component)item, new VariableResolver(){

                        public Object resolveVariable(String name) {
                            if ("each".equals(name)) {
                                return data;
                            }
                            if ("forEachStatus".equals(name)) {
                                return new ForEachStatus(){

                                    public ForEachStatus getPrevious() {
                                        return null;
                                    }

                                    public Object getEach() {
                                        return data;
                                    }

                                    public int getIndex() {
                                        return index;
                                    }

                                    public Integer getBegin() {
                                        return 0;
                                    }

                                    public Integer getEnd() {
                                        return cb.getModel().getSize();
                                    }
                                };
                            }
                            return null;
                        }
                    }, null);
                    if (items.length != 1) {
                        throw new UiException("The model template must have exactly one item, not " + items.length);
                    }
                    Radio nci = (Radio)items[0];
                    if (nci.getValue() == null) {
                        nci.setValue(data);
                    }
                    item.setAttribute("org.zkoss.zul.model.renderAs", (Object)nci);
                    item.detach();
                }
            }
        };
    }

    private class Renderer
    implements Serializable {
        private final RadioRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Radiogroup.this.getRealRenderer();
        }

        private void render(Radio item, Object value, int index) throws Throwable {
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            try {
                this._renderer.render(item, value, index);
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                throw ex;
            }
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

