/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListModel<E>
implements ListModel<E>,
Selectable<E>,
Serializable {
    private transient List<ListDataListener> _listeners = new ArrayList<ListDataListener>();
    protected transient Set<E> _selection = this.newEmptySelection();
    private boolean _multiple;

    protected AbstractListModel() {
    }

    protected void fireEvent(int type, int index0, int index1) {
        ListDataEvent evt = new ListDataEvent(this, type, index0, index1);
        for (ListDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this._listeners.remove(l);
    }

    @Override
    public Set<E> getSelection() {
        return Collections.unmodifiableSet(this._selection);
    }

    @Override
    public void setSelection(Collection<? extends E> selection) {
        if (this.isSelectionChanged(selection)) {
            if (!this._multiple && selection.size() > 1) {
                throw new IllegalArgumentException("Only one selection is allowed, not " + selection);
            }
            this._selection.clear();
            this._selection.addAll(selection);
            if (selection.isEmpty()) {
                this.fireSelectionEvent(null);
            } else {
                this.fireSelectionEvent(selection.iterator().next());
            }
        }
    }

    private boolean isSelectionChanged(Collection<? extends E> selection) {
        if (this._selection.size() != selection.size()) {
            return true;
        }
        for (E e : selection) {
            if (this._selection.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelected(Object obj) {
        return !this.isSelectionEmpty() && (this._selection.size() == 1 ? Objects.equals(this._selection.iterator().next(), (Object)obj) : this._selection.contains(obj));
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._selection.isEmpty();
    }

    @Override
    public boolean addToSelection(E obj) {
        if (this._selection.add(obj)) {
            if (!this._multiple) {
                this._selection.clear();
                this._selection.add(obj);
            }
            this.fireSelectionEvent(obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromSelection(Object obj) {
        if (this._selection.remove(obj)) {
            this.fireEvent(4, -1, -1);
            return true;
        }
        return false;
    }

    @Override
    public void clearSelection() {
        if (!this._selection.isEmpty()) {
            this._selection.clear();
            this.fireEvent(4, -1, -1);
        }
    }

    protected void fireSelectionEvent(E e) {
        this.fireEvent(4, -1, -1);
    }

    protected void removeAllSelection(Collection<?> c) {
        if (this._selection.removeAll(c)) {
            this.fireEvent(4, -1, -1);
        }
    }

    protected void retainAllSelection(Collection<?> c) {
        if (this._selection.retainAll(c)) {
            this.fireEvent(4, -1, -1);
        }
    }

    @Override
    public boolean isMultiple() {
        return this._multiple;
    }

    @Override
    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            this.fireEvent(6, -1, -1);
            if (!multiple && this._selection.size() > 1) {
                E v = this._selection.iterator().next();
                this._selection.clear();
                this._selection.add(v);
                this.fireEvent(4, -1, -1);
            }
        }
    }

    protected Set<E> newEmptySelection() {
        return new LinkedHashSet();
    }

    protected void writeSelection(ObjectOutputStream s) throws IOException {
        s.writeObject(this._selection);
    }

    protected void readSelection(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this._selection = (Set)s.readObject();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.writeSelection(s);
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.readSelection(s);
        this._listeners = new ArrayList<ListDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }

    public Object clone() {
        AbstractListModel clone;
        try {
            clone = (AbstractListModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._listeners = new ArrayList<ListDataListener>();
        clone._selection = clone.newEmptySelection();
        clone._selection.addAll(this._selection);
        return clone;
    }
}

