/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.acegi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.util.CollectionsX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zul.Window;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowWindowEventListener<T extends Event>
implements SerializableEventListener<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(T event) {
        Component comp = event.getTarget();
        Page page = comp.getPage();
        String url = (String)event.getData();
        Execution exec = Executions.getCurrent();
        try {
            this.doModal(page, url);
        }
        finally {
            EventListener listener;
            if (comp.isListenerAvailable(event.getName(), true) && (listener = (EventListener)comp.getAttribute(event.getName())) != null) {
                comp.removeEventListener(event.getName(), listener);
                comp.removeAttribute(event.getName());
            }
        }
    }

    private void doModal(Page page, String url) {
        Object[] urls;
        Execution exec = Executions.getCurrent();
        Component modalwin = exec.createComponents((String)(urls = this.parseUrl(url))[0], null, (Map)urls[1]);
        if (!(modalwin instanceof Window)) {
            throw new UiException("The page must enclosed with a Window component. Check url definition: " + url);
        }
        modalwin.setPage(page);
        ((Window)modalwin).doModal();
    }

    private Object[] parseUrl(String url) {
        Object[] result = new Object[2];
        int j = url.indexOf("?");
        if (j < 0) {
            result[0] = url;
            return result;
        }
        result[0] = url.substring(0, j);
        if (j + 1 >= url.length()) {
            return result;
        }
        url = url.substring(j + 1);
        LinkedList list = new LinkedList();
        CollectionsX.parse(list, (String)url, (char)'&');
        HashMap args = new HashMap();
        for (String s : list) {
            ArrayList pair = new ArrayList(2);
            CollectionsX.parse(pair, (String)s, (char)'=');
            args.put(pair.get(0), pair.get(1));
        }
        result[1] = args;
        return result;
    }
}

