/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.lang.Strings;
import org.zkoss.xel.ExpressionX;

public class AccessInfo
implements Serializable {
    private static final long serialVersionUID = 1463169907348730644L;
    final String commandName;
    final ExpressionX property;
    final ConditionType type;

    public AccessInfo(ExpressionX property, ConditionType type, String command) {
        this.property = property;
        this.type = type;
        this.commandName = command;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public ConditionType getConditionType() {
        return this.type;
    }

    public ExpressionX getProperty() {
        return this.property;
    }

    public static AccessInfo create(Binding binding, String accessExpr, Class<?> expectedType, ConditionType type, String command, boolean ignoreTracker) {
        Binder binder = binding.getBinder();
        if (ConditionType.PROMPT != type && Strings.isEmpty((String)command)) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("condition type is " + (Object)((Object)type) + ", but command is null", binding.getComponent()));
        }
        BindEvaluatorX eval = binder.getEvaluatorX();
        BindContext ctx = BindContextUtil.newBindContext(binder, binding, false, null, binding.getComponent(), null);
        if (ConditionType.PROMPT != type || ignoreTracker) {
            ctx.setAttribute("$IGNORE_TRACKER$", Boolean.TRUE);
        }
        ExpressionX prop = eval.parseExpressionX(ctx, accessExpr, expectedType);
        return new AccessInfo(prop, type, command);
    }
}

