/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.ext.Selectable;

public class TabboxSelectedTabConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 200808190445L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        Tabbox tbx = (Tabbox)comp;
        ListModel model = tbx.getModel();
        if (model != null && !(model instanceof Selectable)) {
            throw new UiException("model doesn't implement Selectable");
        }
        if (val != null) {
            if (model != null) {
                ((Selectable)model).addToSelection(val);
                return IGNORED_VALUE;
            }
            Tabs tabs = ((Tabbox)comp).getTabs();
            if (tabs != null) {
                for (Component child : tabs.getChildren()) {
                    if (!(child instanceof Tab) || !val.equals(((Tab)child).getLabel())) continue;
                    return child;
                }
            }
        }
        if (model != null) {
            Set sels = ((Selectable)model).getSelection();
            if (sels != null && sels.size() > 0) {
                ((Selectable)model).clearSelection();
            }
            return IGNORED_VALUE;
        }
        return null;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        if (val != null) {
            Tabbox tbx = (Tabbox)comp;
            ListModel model = tbx.getModel();
            if (model != null && !(model instanceof Selectable)) {
                throw new UiException("model doesn't implement Selectable");
            }
            if (model != null) {
                Set selection = ((Selectable)model).getSelection();
                if (selection == null || selection.size() == 0) {
                    return null;
                }
                return selection.iterator().next();
            }
            return ((Tab)val).getLabel();
        }
        return null;
    }
}

