/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;

class PartialByteStream
extends ByteArrayOutputStream {
    private final int _from;
    private final int _to;
    private int _ofs;
    private int _cnt;

    PartialByteStream(int from, int to) {
        super(4096);
        this._from = from;
        this._to = to;
    }

    void responseTo(HttpServletResponse response) throws IOException {
        response.setStatus(206);
        response.setContentLength(this._cnt);
        int from = this._from <= this._ofs ? this._from : this._ofs;
        int to = this._to >= 0 && this._to <= this._ofs ? this._to : this._ofs;
        response.setHeader("Content-Range", "bytes " + from + "-" + to + "/" + this._ofs);
        this.writeTo((OutputStream)response.getOutputStream());
    }

    public synchronized void write(int b) {
        int ofs;
        if ((ofs = this._ofs++) >= this._from && (this._to < 0 || ofs <= this._to)) {
            ++this._cnt;
            super.write(b);
        }
    }

    public synchronized void write(byte[] b, int ofs, int len) {
        while (--len >= 0) {
            this.write(b[ofs++]);
        }
    }
}

