/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel;

import java.beans.FeatureDescriptor;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ELResolver {
    public static final String RESOLVABLE_AT_DESIGN_TIME = "resolvableAtDesignTime";
    public static final String TYPE = "type";

    static String message(ELContext context, String name, Object[] props) {
        Locale locale = context.getLocale();
        if (locale == null && (locale = Locale.getDefault()) == null) {
            return "";
        }
        ResourceBundle bundle = ResourceBundle.getBundle("org.zkoss.zel.LocalStrings", locale);
        try {
            String template = bundle.getString(name);
            if (props != null) {
                template = MessageFormat.format(template, props);
            }
            return template;
        }
        catch (MissingResourceException e) {
            return "Missing Resource: '" + name + "' for Locale " + locale.getDisplayName();
        }
    }

    public abstract Object getValue(ELContext var1, Object var2, Object var3) throws NullPointerException, PropertyNotFoundException, ELException;

    public abstract Class<?> getType(ELContext var1, Object var2, Object var3) throws NullPointerException, PropertyNotFoundException, ELException;

    public abstract void setValue(ELContext var1, Object var2, Object var3, Object var4) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException;

    public abstract boolean isReadOnly(ELContext var1, Object var2, Object var3) throws NullPointerException, PropertyNotFoundException, ELException;

    public abstract Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext var1, Object var2);

    public abstract Class<?> getCommonPropertyType(ELContext var1, Object var2);

    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        return null;
    }
}

