/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.video;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import org.zkoss.io.NullInputStream;
import org.zkoss.lang.SystemException;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.video.Video;

public class AVideo
implements Video,
Serializable {
    protected static final InputStream DYNAMIC_STREAM = new NullInputStream();
    private final byte[] _data;
    protected final transient InputStream _isdata;
    private final URL _url;
    private final File _file;
    private String _format;
    private String _ctype;
    private final String _name;

    public AVideo(String name, byte[] data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        this._name = name;
        this._data = data;
        this._isdata = null;
        this._url = null;
        this._file = null;
    }

    public AVideo(String name, InputStream isdata) throws IOException {
        if (isdata == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this._name = name;
        this._isdata = isdata;
        this._data = null;
        this._url = null;
        this._file = null;
    }

    public AVideo(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this._name = this.getName(url);
        this._url = url;
        this._isdata = DYNAMIC_STREAM;
        this._data = null;
        this._file = null;
    }

    public AVideo(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        this._name = file.getName();
        this._file = file;
        this._isdata = DYNAMIC_STREAM;
        this._data = null;
        this._url = null;
    }

    public AVideo(String filename) throws IOException {
        this(new File(filename));
    }

    public AVideo(InputStream is) throws IOException {
        this(null, is);
    }

    public String getName() {
        return this._name;
    }

    private String getName(URL url) {
        String name = url.getPath();
        if (name != null) {
            int j;
            int i = name.lastIndexOf(File.pathSeparatorChar);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            if (File.pathSeparatorChar != '/' && (j = name.lastIndexOf(47)) >= 0) {
                name = name.substring(j + 1);
            }
        }
        return name;
    }

    public String getContentType() {
        if (this._ctype == null) {
            this._ctype = AVideo.getContentType(this.getFormat());
        }
        return this._ctype;
    }

    private static String getContentType(String format) {
        String ctype = ContentTypes.getContentType(format);
        return ctype != null ? ctype : "video/" + format;
    }

    public InputStream getStreamData() {
        try {
            if (this._url != null) {
                InputStream is = this._url.openStream();
                return is != null ? new BufferedInputStream(is) : null;
            }
            if (this._file != null) {
                return new BufferedInputStream(new FileInputStream(this._file));
            }
        }
        catch (IOException ex) {
            throw new SystemException("Unable to read " + (this._url != null ? this._url.toString() : this._file.toString()), (Throwable)ex);
        }
        if (this._isdata != null) {
            return this._isdata;
        }
        return new ByteArrayInputStream(this._data);
    }

    public final String getStringData() {
        throw this.newIllegalStateException();
    }

    public final Reader getReaderData() {
        throw this.newIllegalStateException();
    }

    private final IllegalStateException newIllegalStateException() {
        return new IllegalStateException(this._isdata != null ? "Use getStreamData() instead" : "Use getByteData() instead");
    }

    public String getFormat() {
        if (this._format == null) {
            this._format = this.getFormatByName(this._name);
        }
        return this._format;
    }

    private String getFormatByName(String name) {
        int k;
        int j;
        if (name != null && (j = name.lastIndexOf(46) + 1) > (k = name.lastIndexOf(47) + 1) && j < name.length()) {
            return name.substring(j);
        }
        return null;
    }

    public boolean isContentDisposition() {
        return true;
    }

    public boolean isBinary() {
        return true;
    }

    public final boolean inMemory() {
        return this._data != null;
    }

    public byte[] getByteData() {
        if (this._data == null) {
            throw new IllegalStateException("Use getStreamData() instead");
        }
        return this._data;
    }
}

