/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.tcp;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import zmq.io.net.Address;
import zmq.io.net.ProtocolFamily;
import zmq.io.net.StandardProtocolFamily;

public class TcpAddress
implements Address.IZAddress {
    private final InetSocketAddress address;
    private final SocketAddress sourceAddress;

    public TcpAddress(String addr, boolean ipv6) {
        String[] strings = addr.split(";");
        this.address = this.resolve(strings[0], ipv6, false);
        this.sourceAddress = strings.length == 2 && !"".equals(strings[1]) ? this.resolve(strings[1], ipv6, false) : null;
    }

    @Override
    public ProtocolFamily family() {
        if (this.address.getAddress() instanceof Inet6Address) {
            return StandardProtocolFamily.INET6;
        }
        return StandardProtocolFamily.INET;
    }

    public String toString() {
        return this.toString(this.address.getPort());
    }

    @Override
    public String toString(int port) {
        if (this.address == null) {
            return "";
        }
        int addressPort = this.address.getPort();
        if (addressPort == 0) {
            addressPort = port;
        }
        if (this.address.getAddress() instanceof Inet6Address) {
            return "tcp://[" + this.address.getAddress().getHostAddress() + "]:" + addressPort;
        }
        return "tcp://" + this.address.getAddress().getHostAddress() + ":" + addressPort;
    }

    @Override
    public InetSocketAddress resolve(String name, boolean ipv6, boolean local) {
        int port;
        int delimiter = name.lastIndexOf(58);
        if (delimiter < 0) {
            throw new IllegalArgumentException(name);
        }
        String addrStr = name.substring(0, delimiter);
        String portStr = name.substring(delimiter + 1);
        if (addrStr.length() >= 2 && addrStr.charAt(0) == '[' && addrStr.charAt(addrStr.length() - 1) == ']') {
            addrStr = addrStr.substring(1, addrStr.length() - 1);
        }
        if (portStr.equals("*") || portStr.equals("0")) {
            port = 0;
        } else {
            port = Integer.parseInt(portStr);
            if (port == 0) {
                throw new IllegalArgumentException(name);
            }
        }
        InetAddress addrNet = null;
        if (addrStr.equals("*")) {
            addrStr = "0.0.0.0";
        }
        try {
            for (InetAddress ia : InetAddress.getAllByName(addrStr)) {
                if (ipv6 && !(ia instanceof Inet6Address)) continue;
                addrNet = ia;
                break;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        if (addrNet == null) {
            throw new IllegalArgumentException(name);
        }
        return new InetSocketAddress(addrNet, port);
    }

    @Override
    public SocketAddress address() {
        return this.address;
    }

    @Override
    public SocketAddress sourceAddress() {
        return this.sourceAddress;
    }

    public static class TcpAddressMask
    extends TcpAddress {
        public TcpAddressMask(String addr, boolean ipv6) {
            super(addr, ipv6);
        }

        public boolean matchAddress(SocketAddress addr) {
            return this.address().equals(addr);
        }
    }
}

