/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZThread {
    private ZThread() {
    }

    public static void start(IDetachedRunnable runnable, Object ... args) {
        ShimThread shim = new ShimThread(runnable, args);
        shim.setDaemon(true);
        shim.start();
    }

    public static ZMQ.Socket fork(ZContext ctx, IAttachedRunnable runnable, Object ... args) {
        ZMQ.Socket pipe = ctx.createSocket(SocketType.PAIR);
        if (pipe == null) {
            return null;
        }
        pipe.bind(String.format("inproc://zctx-pipe-%d", pipe.hashCode()));
        ZContext ccontext = ZContext.shadow(ctx);
        ZMQ.Socket cpipe = ccontext.createSocket(SocketType.PAIR);
        if (cpipe == null) {
            return null;
        }
        cpipe.connect(String.format("inproc://zctx-pipe-%d", pipe.hashCode()));
        ShimThread shim = new ShimThread(ccontext, runnable, args, cpipe);
        shim.start();
        return pipe;
    }

    private static class ShimThread
    extends Thread {
        private ZContext ctx;
        private IAttachedRunnable attachedRunnable;
        private IDetachedRunnable detachedRunnable;
        private Object[] args;
        private ZMQ.Socket pipe;

        protected ShimThread(ZContext ctx, IAttachedRunnable runnable, Object[] args, ZMQ.Socket pipe) {
            assert (ctx != null);
            assert (pipe != null);
            assert (runnable != null);
            this.ctx = ctx;
            this.attachedRunnable = runnable;
            this.args = args;
            this.pipe = pipe;
        }

        public ShimThread(IDetachedRunnable runnable, Object[] args) {
            assert (runnable != null);
            this.detachedRunnable = runnable;
            this.args = args;
        }

        @Override
        public void run() {
            if (this.attachedRunnable != null) {
                block4: {
                    try {
                        this.attachedRunnable.run(this.args, this.ctx, this.pipe);
                    }
                    catch (ZMQException e) {
                        if (e.getErrorCode() == ZMQ.Error.ETERM.getCode()) break block4;
                        throw e;
                    }
                }
                this.ctx.destroy();
            } else {
                this.detachedRunnable.run(this.args);
            }
        }
    }

    @FunctionalInterface
    public static interface IDetachedRunnable {
        public void run(Object[] var1);
    }

    @FunctionalInterface
    public static interface IAttachedRunnable {
        public void run(Object[] var1, ZContext var2, ZMQ.Socket var3);
    }
}

