/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayDeque;
import java.util.Deque;
import zmq.Address;
import zmq.Blob;
import zmq.Ctx;
import zmq.Dist;
import zmq.IOThread;
import zmq.Msg;
import zmq.Mtrie;
import zmq.Options;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;

class XPub
extends SocketBase {
    private final Mtrie subscriptions;
    private final Dist dist;
    private boolean verboseSubs;
    private boolean verboseUnsubs;
    private boolean more;
    private boolean lossy;
    private final Deque<Blob> pendingData;
    private final Deque<Integer> pendingFlags;
    private static Mtrie.IMtrieHandler markAsMatching = new Mtrie.IMtrieHandler(){

        @Override
        public void invoke(Pipe pipe, byte[] data, int size, Object arg) {
            XPub self = (XPub)arg;
            self.dist.match(pipe);
        }
    };
    private static Mtrie.IMtrieHandler sendUnsubscription = new Mtrie.IMtrieHandler(){

        @Override
        public void invoke(Pipe pipe, byte[] data, int size, Object arg) {
            XPub self = (XPub)arg;
            if (self.options.type != 1) {
                byte[] unsub = new byte[size + 1];
                unsub[0] = 0;
                System.arraycopy(data, 0, unsub, 1, size);
                self.pendingData.add(Blob.createBlob(unsub, false));
                self.pendingFlags.add(0);
            }
        }
    };

    public XPub(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 9;
        this.verboseSubs = false;
        this.verboseUnsubs = false;
        this.more = false;
        this.lossy = true;
        this.subscriptions = new Mtrie();
        this.dist = new Dist();
        this.pendingData = new ArrayDeque<Blob>();
        this.pendingFlags = new ArrayDeque<Integer>();
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean subscribeToAll) {
        assert (pipe != null);
        this.dist.attach(pipe);
        if (subscribeToAll) {
            this.subscriptions.add(null, pipe);
        }
        this.xreadActivated(pipe);
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        Msg sub = null;
        while ((sub = pipe.read()) != null) {
            byte[] data = sub.data();
            int size = sub.size();
            if (size > 0 && (data[0] == 0 || data[0] == 1)) {
                boolean unique = data[0] == 0 ? this.subscriptions.rm(data, 1, pipe) : this.subscriptions.add(data, 1, pipe);
                if (this.options.type != 9 || !unique && (data[0] != 1 || !this.verboseSubs) && (data[0] != 0 || !this.verboseUnsubs)) continue;
                this.pendingData.add(Blob.createBlob(data, true));
                this.pendingFlags.add(0);
                continue;
            }
            this.pendingData.add(Blob.createBlob(data, true));
            this.pendingFlags.add(sub.flags());
        }
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        this.dist.activated(pipe);
    }

    @Override
    public boolean xsetsockopt(int option, Object optval) {
        if (option == 40) {
            this.verboseSubs = (Integer)optval == 1;
        } else if (option == 78) {
            this.verboseUnsubs = (Integer)optval == 1;
        } else if (option == 69) {
            this.lossy = (Integer)optval == 0;
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        this.subscriptions.rm(pipe, sendUnsubscription, this, !this.verboseUnsubs);
        this.dist.terminated(pipe);
    }

    @Override
    protected boolean xsend(Msg msg) {
        boolean msgMore = msg.hasMore();
        if (!this.more) {
            this.subscriptions.match(msg.buf(), msg.size(), markAsMatching, this);
        }
        if (this.lossy || this.dist.checkHwm()) {
            if (this.dist.sendToMatching(msg)) {
                if (!msgMore) {
                    this.dist.unmatch();
                }
                this.more = msgMore;
                return true;
            }
        } else {
            this.errno.set(35);
        }
        return false;
    }

    @Override
    protected boolean xhasOut() {
        return this.dist.hasOut();
    }

    @Override
    protected Msg xrecv() {
        if (this.pendingData.isEmpty()) {
            this.errno.set(35);
            return null;
        }
        Blob first = this.pendingData.pollFirst();
        Msg msg = new Msg(first.data());
        int flags = this.pendingFlags.pollFirst();
        msg.setFlags(flags);
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return !this.pendingData.isEmpty();
    }

    public static class XPubSession
    extends SessionBase {
        public XPubSession(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            super(ioThread, connect, socket, options, addr);
        }
    }
}

