/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.gradle.jruby.internal.resolver;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import org.ysb33r.gradle.jruby.api.gems.GemNotFoundException;
import org.ysb33r.gradle.jruby.api.resolver.IvyXmlFactory;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;

public class RatpackServerFactory {
    static RatpackServer createAndStartServer(IvyXmlFactory ivyXmlFactory, File localCachePath) {
        try {
            return RatpackServer.start(server -> server.serverConfig(ServerConfig.embedded().publicAddress(new URI("http://localhost")).port(0).baseDir(localCachePath)).handlers(chain -> chain.get(":group/:module/:revision/ivy.xml", ctx -> {
                try {
                    Path ivyXml = ivyXmlFactory.ivyXmlPath((String)ctx.getAllPathTokens().get((Object)"group"), (String)ctx.getAllPathTokens().get((Object)"module"), (String)ctx.getAllPathTokens().get((Object)"revision"));
                    ctx.getResponse().contentType((CharSequence)"text/xml").sendFile(ivyXml);
                }
                catch (GemNotFoundException e) {
                    ctx.clientError(404);
                }
            }).get(":group/:module/:revision/ivy.xml.sha1", ctx -> {
                try {
                    Path ivyXmlSha1 = ivyXmlFactory.ivyXmlSha1((String)ctx.getAllPathTokens().get((Object)"group"), (String)ctx.getAllPathTokens().get((Object)"module"), (String)ctx.getAllPathTokens().get((Object)"revision"));
                    ctx.getResponse().contentType((CharSequence)"text/plain").sendFile(ivyXmlSha1);
                }
                catch (GemNotFoundException e) {
                    ctx.clientError(404);
                }
            }).get(":group/:module", ctx -> {
                try {
                    String listing = ivyXmlFactory.directoryListing((String)ctx.getAllPathTokens().get((Object)"group"), (String)ctx.getAllPathTokens().get((Object)"module"));
                    ctx.getResponse().contentType((CharSequence)"text/html").send(listing);
                }
                catch (GemNotFoundException e) {
                    ctx.clientError(404);
                }
            }).get(ctx -> ctx.clientError(403))));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start Ratpack", e);
        }
    }
}

