/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.gradle.jruby.api.gems;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.Tuple2;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ysb33r.gradle.jruby.api.gems.GemVersionException;
import org.ysb33r.gradle.jruby.internal.core.Transform;

public class GemVersion
implements Comparable<GemVersion>,
GroovyObject {
    public static final GemVersion NO_VERSION;
    public static final GemVersion EVERYTHING;
    public static final String MAX_VERSION = "99999";
    public static final String MIN_VERSION = "0.0.0";
    private static final String LOW_IN;
    private static final String UP_IN;
    private static final Pattern DOT_PLUS;
    private static final Pattern PLUS;
    private static final Pattern DIGITS_PLUS;
    private static final Pattern OPEN_BOTTOM;
    private static final Pattern OPEN_TOP;
    private static final Pattern RANGE;
    private static final Pattern ONLY_DIGITS;
    private static final Pattern DIGITS_AND_DOTS;
    private static final Pattern GREATER_EQUAL;
    private static final Pattern GREATER;
    private static final Pattern EQUAL;
    private static final Pattern NOT_EQUAL;
    private static final Pattern LESS;
    private static final Pattern LESS_EQUAL;
    private static final Pattern TWIDDLE_WAKKA;
    private static final String VERSION_SPLIT;
    private static final String PAD_ZERO;
    private static final String EMPTY = "";
    private static final String NOT_GEM_REQ = "This does not look like a standard GEM version requirement";
    private final String low;
    private final String high;
    private final Boundary lowBoundary;
    private final Boundary highBoundary;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    private GemVersion(Boundary pre, String low, String high, Boundary post) {
        Boundary boundary;
        String string;
        String string2;
        Boundary boundary2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.lowBoundary = boundary2 = pre;
        this.low = string2 = low;
        this.high = string = high;
        this.highBoundary = boundary = post;
    }

    private GemVersion(String gradleVersionPattern) {
        MetaClass metaClass;
        CallSite[] callSiteArray = GemVersion.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String cleanedString = ShortTypeHandling.castToString((Object)callSiteArray[0].call((Object)gradleVersionPattern, ScriptBytecodeAdapter.bitwiseNegate((Object)"\\p{Blank}"), (Object)EMPTY));
        MatchResult dotPlus = (MatchResult)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)cleanedString, (Object)DOT_PLUS), MatchResult.class);
        MatchResult plus = (MatchResult)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)cleanedString, (Object)PLUS), MatchResult.class);
        MatchResult digitsPlus = (MatchResult)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)cleanedString, (Object)DIGITS_PLUS), MatchResult.class);
        MatchResult openBottom = (MatchResult)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)cleanedString, (Object)OPEN_BOTTOM), MatchResult.class);
        MatchResult openTop = (MatchResult)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)cleanedString, (Object)OPEN_TOP), MatchResult.class);
        MatchResult range = (MatchResult)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)cleanedString, (Object)RANGE), MatchResult.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call((Object)dotPlus))) {
            String base = ShortTypeHandling.castToString((Object)callSiteArray[2].call(callSiteArray[3].call((Object)dotPlus, (Object)0), (Object)1));
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[4].callCurrent((GroovyObject)this, (Object)base, (Object)PAD_ZERO);
                this.low = ShortTypeHandling.castToString((Object)object);
            } else {
                String string;
                this.low = string = this.padVersion(base, PAD_ZERO);
            }
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[5].callCurrent((GroovyObject)this, (Object)base, (Object)MAX_VERSION);
                this.high = ShortTypeHandling.castToString((Object)object);
            } else {
                String string;
                this.high = string = this.padVersion(base, MAX_VERSION);
            }
            Object object = callSiteArray[6].callGetProperty(Boundary.class);
            this.lowBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object, Boundary.class);
            Object object2 = callSiteArray[7].callGetProperty(Boundary.class);
            this.highBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object2, Boundary.class);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].call((Object)plus))) {
            String string;
            this.low = string = MIN_VERSION;
            Object object = callSiteArray[9].callGetProperty(Boundary.class);
            this.lowBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object, Boundary.class);
            Object object3 = callSiteArray[10].callGetProperty(Boundary.class);
            this.highBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object3, Boundary.class);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call((Object)digitsPlus))) {
            Object object = callSiteArray[12].callGetProperty(Boundary.class);
            this.lowBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object, Boundary.class);
            Object object4 = callSiteArray[13].callGetProperty(Boundary.class);
            this.highBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object4, Boundary.class);
            GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[14].call(callSiteArray[15].call((Object)digitsPlus, (Object)0), (Object)1), callSiteArray[16].call(callSiteArray[17].call((Object)digitsPlus, (Object)0), (Object)2)}, new String[]{EMPTY, ".", EMPTY});
            this.low = ShortTypeHandling.castToString((Object)gStringImpl);
            GStringImpl gStringImpl2 = new GStringImpl(new Object[]{callSiteArray[18].call(callSiteArray[19].call((Object)digitsPlus, (Object)0), (Object)1), MAX_VERSION}, new String[]{EMPTY, ".", EMPTY});
            this.high = ShortTypeHandling.castToString((Object)gStringImpl2);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].call((Object)openBottom))) {
            Object object = callSiteArray[21].callGetProperty(Boundary.class);
            this.lowBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object, Boundary.class);
            Object object5 = callSiteArray[22].call(callSiteArray[23].call((Object)openBottom, (Object)0), (Object)1);
            this.high = ShortTypeHandling.castToString((Object)object5);
            Object object6 = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[24].call(callSiteArray[25].call((Object)openBottom, (Object)0), (Object)2), (Object)UP_IN) ? callSiteArray[26].callGetProperty(Boundary.class) : callSiteArray[27].callGetProperty(Boundary.class);
            this.highBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object6, Boundary.class);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call((Object)openTop))) {
            Object object = callSiteArray[29].callGetProperty(Boundary.class);
            this.highBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object, Boundary.class);
            Object object7 = callSiteArray[30].call(callSiteArray[31].call((Object)openTop, (Object)0), (Object)2);
            this.low = ShortTypeHandling.castToString((Object)object7);
            Object object8 = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[32].call(callSiteArray[33].call((Object)openTop, (Object)0), (Object)1), (Object)LOW_IN) ? callSiteArray[34].callGetProperty(Boundary.class) : callSiteArray[35].callGetProperty(Boundary.class);
            this.lowBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object8, Boundary.class);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].call((Object)range))) {
            Object object = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[37].call(callSiteArray[38].call((Object)range, (Object)0), (Object)1), (Object)LOW_IN) ? callSiteArray[39].callGetProperty(Boundary.class) : callSiteArray[40].callGetProperty(Boundary.class);
            this.lowBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object, Boundary.class);
            Object object9 = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[41].call(callSiteArray[42].call((Object)range, (Object)0), (Object)4), (Object)UP_IN) ? callSiteArray[43].callGetProperty(Boundary.class) : callSiteArray[44].callGetProperty(Boundary.class);
            this.highBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object9, Boundary.class);
            Object object10 = callSiteArray[45].call(callSiteArray[46].call((Object)range, (Object)0), (Object)2);
            this.low = ShortTypeHandling.castToString((Object)object10);
            Object object11 = callSiteArray[47].call(callSiteArray[48].call((Object)range, (Object)0), (Object)3);
            this.high = ShortTypeHandling.castToString((Object)object11);
        } else {
            String string;
            String string2;
            this.low = string2 = cleanedString;
            this.high = string = cleanedString;
            Object object = callSiteArray[49].callGetProperty(Boundary.class);
            this.lowBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object, Boundary.class);
            Object object12 = callSiteArray[50].callGetProperty(Boundary.class);
            this.highBoundary = (Boundary)ShortTypeHandling.castToEnum((Object)object12, Boundary.class);
        }
    }

    public static GemVersion gemVersionFromGradleIvyRequirement(String singleRequirement) {
        return new GemVersion(singleRequirement);
    }

    public static List<GemVersion> gemVersionsFromMultipleGemRequirements(String multipleRequirements) {
        public final class _gemVersionsFromMultipleGemRequirements_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _gemVersionsFromMultipleGemRequirements_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public GemVersion doCall(String it) {
                return GemVersion.gemVersionFromGemRequirement(it.trim());
            }

            @Generated
            public GemVersion call(String it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _gemVersionsFromMultipleGemRequirements_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _gemVersionsFromMultipleGemRequirements_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _gemVersionsFromMultipleGemRequirements_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)it, (Object)ScriptBytecodeAdapter.getField(_gemVersionsFromMultipleGemRequirements_closure2.class, GemVersion.class, (String)"NO_VERSION"));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _gemVersionsFromMultipleGemRequirements_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.findAll(Transform.toList((Object[])ScriptBytecodeAdapter.castToType((Object)multipleRequirements.split(",\\s*"), Object[].class), (Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _gemVersionsFromMultipleGemRequirements_closure1(GemVersion.class, GemVersion.class)), Function.class)), (Closure)new _gemVersionsFromMultipleGemRequirements_closure2(GemVersion.class, GemVersion.class));
    }

    public static GemVersion singleGemVersionFromMultipleGemRequirements(String multipleRequirements) {
        List<GemVersion> gemVersions = GemVersion.gemVersionsFromMultipleGemRequirements(multipleRequirements);
        if (gemVersions.isEmpty()) {
            return EVERYTHING;
        }
        if (gemVersions.size() == 1) {
            return (GemVersion)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.first(gemVersions), GemVersion.class);
        }
        public final class _singleGemVersionFromMultipleGemRequirements_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _singleGemVersionFromMultipleGemRequirements_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public GemVersion doCall(Object range, Object value) {
                return ((GemVersion)range).intersect((GemVersion)ScriptBytecodeAdapter.castToType((Object)value, GemVersion.class));
            }

            @Generated
            public GemVersion call(Object range, Object value) {
                return this.doCall(range, value);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _singleGemVersionFromMultipleGemRequirements_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (GemVersion)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.inject((Collection)DefaultGroovyMethods.getAt(gemVersions, (Range)new IntRange(true, 1, -1)), (Object)DefaultGroovyMethods.first(gemVersions), (Closure)new _singleGemVersionFromMultipleGemRequirements_closure3(GemVersion.class, GemVersion.class)), GemVersion.class);
    }

    public static GemVersion gemVersionFromGemRequirement(String singleRequirement) {
        if (StringGroovyMethods.matches((CharSequence)singleRequirement, (Pattern)GREATER_EQUAL)) {
            return new GemVersion(Boundary.INCLUSIVE, GemVersion.getVersionFromRequirement(singleRequirement, GREATER_EQUAL), null, Boundary.OPEN_ENDED);
        }
        if (StringGroovyMethods.matches((CharSequence)singleRequirement, (Pattern)GREATER)) {
            return new GemVersion(Boundary.EXCLUSIVE, GemVersion.getVersionFromRequirement(singleRequirement, GREATER), null, Boundary.OPEN_ENDED);
        }
        if (StringGroovyMethods.matches((CharSequence)singleRequirement, (Pattern)EQUAL)) {
            String exact = GemVersion.getVersionFromRequirement(singleRequirement, EQUAL);
            return new GemVersion(Boundary.INCLUSIVE, exact, exact, Boundary.INCLUSIVE);
        }
        if (StringGroovyMethods.matches((CharSequence)singleRequirement, (Pattern)NOT_EQUAL)) {
            Object v0;
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{singleRequirement}, new String[]{"'", "' is supported by Ivy."})));
                v0 = null;
            } else {
                v0 = null;
            }
            return NO_VERSION;
        }
        if (StringGroovyMethods.matches((CharSequence)singleRequirement, (Pattern)LESS_EQUAL)) {
            return new GemVersion(Boundary.OPEN_ENDED, null, GemVersion.getVersionFromRequirement(singleRequirement, LESS_EQUAL), Boundary.INCLUSIVE);
        }
        if (StringGroovyMethods.matches((CharSequence)singleRequirement, (Pattern)LESS)) {
            return new GemVersion(Boundary.OPEN_ENDED, null, GemVersion.getVersionFromRequirement(singleRequirement, LESS), Boundary.EXCLUSIVE);
        }
        if (StringGroovyMethods.matches((CharSequence)singleRequirement, (Pattern)TWIDDLE_WAKKA)) {
            return GemVersion.parseTwiddleWakka(singleRequirement);
        }
        if (StringGroovyMethods.matches((CharSequence)singleRequirement, (Pattern)DIGITS_AND_DOTS)) {
            return new GemVersion(Boundary.INCLUSIVE, singleRequirement, singleRequirement, Boundary.INCLUSIVE);
        }
        throw (Throwable)new GemVersionException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{singleRequirement}, new String[]{"'", "' does not look like a GEM version requirement"})));
    }

    public boolean isLowInclusive() {
        return ScriptBytecodeAdapter.compareEqual((Object)((Object)this.lowBoundary), (Object)((Object)Boundary.INCLUSIVE));
    }

    public boolean isHighInclusive() {
        return ScriptBytecodeAdapter.compareEqual((Object)((Object)this.highBoundary), (Object)((Object)Boundary.INCLUSIVE));
    }

    public boolean isHighOpenEnded() {
        return ScriptBytecodeAdapter.compareEqual((Object)((Object)this.highBoundary), (Object)((Object)Boundary.OPEN_ENDED));
    }

    public GemVersion intersect(String otherVersion) {
        return this.intersect(GemVersion.gemVersionFromGradleIvyRequirement(otherVersion));
    }

    public GemVersion intersect(GemVersion other) {
        Tuple2<String, Boundary> newLowVersionSpec = this.intersect(this.low, this.lowBoundary, other.getLow(), other.lowBoundary, true);
        Tuple2<String, Boundary> newHighVersionSpec = this.intersect(this.high, this.highBoundary, other.getHigh(), other.highBoundary, false);
        GemVersion intersection = new GemVersion((Boundary)ShortTypeHandling.castToEnum((Object)newLowVersionSpec.getV2(), Boundary.class), ShortTypeHandling.castToString((Object)newLowVersionSpec.getV1()), ShortTypeHandling.castToString((Object)newHighVersionSpec.getV1()), (Boundary)ShortTypeHandling.castToEnum((Object)newHighVersionSpec.getV2(), Boundary.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)intersection, (Object)this)) {
            if (this.compare(this.low, other.getLow()) >= 0 && this.compare(other.getLow(), this.high) < 0 && this.compare(this.high, other.getHigh()) <= 0) {
                return intersection;
            }
            return NO_VERSION;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)intersection, (Object)other)) {
            if (this.compare(other.getLow(), this.low) >= 0 && this.compare(this.low, other.getHigh()) < 0 && this.compare(other.getHigh(), this.high) <= 0) {
                return intersection;
            }
            return NO_VERSION;
        }
        return intersection;
    }

    public Tuple2<String, Boundary> intersect(String version, Boundary boundary, String otherVersion, Boundary otherBoundary, boolean low) {
        Boundary newBoundary = null;
        String newVersion = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)version) && DefaultTypeTransformation.booleanUnbox((Object)otherVersion)) {
            Boundary boundary2;
            String string;
            newVersion = string = otherVersion;
            newBoundary = boundary2 = otherBoundary;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)version) && !DefaultTypeTransformation.booleanUnbox((Object)otherVersion)) {
            Boundary boundary3;
            String string;
            newVersion = string = version;
            newBoundary = boundary3 = boundary;
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)version) && !DefaultTypeTransformation.booleanUnbox((Object)otherVersion)) {
            Boundary boundary4;
            Object var12_12 = null;
            newVersion = ShortTypeHandling.castToString(var12_12);
            newBoundary = boundary4 = boundary;
        } else {
            int compareLow = low ? this.compare(version, otherVersion) : this.compare(otherVersion, version);
            if (compareLow < 0) {
                Boundary boundary5;
                String string;
                newVersion = string = otherVersion;
                newBoundary = boundary5 = otherBoundary;
            } else if (compareLow > 0) {
                Boundary boundary6;
                String string;
                newVersion = string = version;
                newBoundary = boundary6 = boundary;
            } else {
                String string;
                Boundary boundary7;
                newBoundary = boundary7 = ScriptBytecodeAdapter.compareEqual((Object)((Object)boundary), (Object)((Object)Boundary.INCLUSIVE)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)otherBoundary), (Object)((Object)Boundary.INCLUSIVE)) ? Boundary.INCLUSIVE : Boundary.EXCLUSIVE;
                newVersion = string = version;
            }
        }
        return new Tuple2((Object)newVersion, (Object)newBoundary);
    }

    @Override
    public int compareTo(GemVersion other) {
        int loCompare = this.compare(this.low, other.getLow());
        if (loCompare != 0) {
            return loCompare;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)this.lowBoundary), (Object)((Object)other.lowBoundary))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.lowBoundary), (Object)((Object)Boundary.OPEN_ENDED))) {
                return -1;
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)other.lowBoundary), (Object)((Object)Boundary.OPEN_ENDED))) {
                return 1;
            }
            return ScriptBytecodeAdapter.compareEqual((Object)((Object)this.lowBoundary), (Object)((Object)Boundary.INCLUSIVE)) ? -1 : 1;
        }
        int hiCompare = this.compare(this.high, other.getHigh());
        if (hiCompare != 0) {
            return hiCompare;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)this.highBoundary), (Object)((Object)other.highBoundary))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.highBoundary), (Object)((Object)Boundary.OPEN_ENDED))) {
                return 1;
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)other.highBoundary), (Object)((Object)Boundary.OPEN_ENDED))) {
                return -1;
            }
            return ScriptBytecodeAdapter.compareEqual((Object)((Object)this.highBoundary), (Object)((Object)Boundary.INCLUSIVE)) ? 1 : -1;
        }
        return 0;
    }

    public boolean conflict() {
        return this.compare(this.stripNonIntegerTail(this.low), this.stripNonIntegerTail(this.high)) == 1;
    }

    public String toString() {
        if (ScriptBytecodeAdapter.compareEqual((Object)this, (Object)EVERYTHING)) {
            return "+";
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this, (Object)NO_VERSION)) {
            return "]0,0[";
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.lowBoundary), (Object)((Object)Boundary.INCLUSIVE)) && ScriptBytecodeAdapter.compareEqual((Object)((Object)this.highBoundary), (Object)((Object)Boundary.INCLUSIVE)) && ScriptBytecodeAdapter.compareEqual((Object)this.low, (Object)this.high)) {
            return this.low;
        }
        Object[] objectArray = new Object[4];
        Boundary boundary = this.lowBoundary;
        String string = boundary != null ? boundary.getLow() : null;
        objectArray[0] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : EMPTY;
        String string2 = this.low;
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : EMPTY;
        String string3 = this.high;
        objectArray[2] = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : EMPTY;
        Boundary boundary2 = this.highBoundary;
        String string4 = boundary2 != null ? boundary2.getHigh() : null;
        objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)string4) ? string4 : EMPTY;
        return ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{EMPTY, EMPTY, ",", EMPTY, EMPTY}));
    }

    private static GemVersion parseTwiddleWakka(String singleRequirement) {
        String base = GemVersion.getVersionFromRequirement(singleRequirement, TWIDDLE_WAKKA);
        List parts = StringGroovyMethods.tokenize((CharSequence)base, (CharSequence)VERSION_SPLIT);
        if (1 == parts.size()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)base, (Object)ONLY_DIGITS))) {
                return new GemVersion(Boundary.INCLUSIVE, base, null, Boundary.OPEN_ENDED);
            }
            throw (Throwable)new GemVersionException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{singleRequirement}, new String[]{"'", "' does not look like a correctly formatted GEM twiddle-wakka"})));
        }
        public final class _parseTwiddleWakka_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _parseTwiddleWakka_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Matcher doCall(Object it) {
                return (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)it, (Object)GemVersion.pfaccess$0(null)), Matcher.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Matcher doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseTwiddleWakka_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        String lastNumberPart = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.find((Collection)DefaultGroovyMethods.reverse((List)DefaultGroovyMethods.getAt((List)parts, (Range)new IntRange(true, 0, -2))), (Closure)new _parseTwiddleWakka_closure4(GemVersion.class, GemVersion.class)));
        if (lastNumberPart == null) {
            throw (Throwable)new GemVersionException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{singleRequirement}, new String[]{"Cannot extract last number part from '", "'. "}).plus(NOT_GEM_REQ)));
        }
        int bottomAdds = 3 - parts.size();
        if (bottomAdds < 0) {
            int n;
            bottomAdds = n = 0;
        }
        Integer nextUp = (Integer)ScriptBytecodeAdapter.castToType((Object)NumberNumberPlus.plus((Number)StringGroovyMethods.toInteger((CharSequence)lastNumberPart), (Number)1), Integer.class);
        String leader = ShortTypeHandling.castToString((Object)(parts.size() <= 2 ? EMPTY : new GStringImpl(new Object[]{DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.getAt((List)parts, (Range)new IntRange(true, 0, -3)), (String)VERSION_SPLIT)}, new String[]{EMPTY, "."})));
        GemVersion gemVersion = new GemVersion(Boundary.INCLUSIVE, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{base, StringGroovyMethods.multiply((CharSequence)".0", (Number)bottomAdds)}, new String[]{EMPTY, EMPTY, EMPTY})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{leader, nextUp}, new String[]{EMPTY, EMPTY, ".0"})), Boundary.EXCLUSIVE);
        try {
            return gemVersion;
        }
        catch (NumberFormatException e) {
            throw (Throwable)new GemVersionException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{singleRequirement}, new String[]{"Can extract last number part from '", "'. "}).plus(NOT_GEM_REQ)), e);
        }
    }

    private static String getVersionFromRequirement(String gemRevision, Pattern matchPattern) {
        CallSite[] callSiteArray = GemVersion.$getCallSiteArray();
        Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)gemRevision, (Object)matchPattern);
        return ShortTypeHandling.castToString((Object)callSiteArray[51].call(callSiteArray[52].call((Object)matcher, (Object)0), (Object)1));
    }

    private int compare(String lhs, String rhs) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)lhs) && !DefaultTypeTransformation.booleanUnbox((Object)rhs)) {
            return 0;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)lhs) && DefaultTypeTransformation.booleanUnbox((Object)rhs)) {
            return -1;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)lhs) && !DefaultTypeTransformation.booleanUnbox((Object)rhs)) {
            return -1;
        }
        List lhsParts = StringGroovyMethods.tokenize((CharSequence)lhs, (CharSequence)VERSION_SPLIT);
        List rhsParts = StringGroovyMethods.tokenize((CharSequence)rhs, (CharSequence)VERSION_SPLIT);
        int i = 0;
        while (i < lhsParts.size() && i < rhsParts.size()) {
            int n;
            int n2;
            int n3;
            int n4;
            int cmp = 0;
            boolean lhsNumerical = StringGroovyMethods.matches((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)lhsParts, (int)i), CharSequence.class)), (Pattern)ONLY_DIGITS);
            boolean rhsNumerical = StringGroovyMethods.matches((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)rhsParts, (int)i), CharSequence.class)), (Pattern)ONLY_DIGITS);
            cmp = lhsNumerical && rhsNumerical ? (n4 = StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)lhsParts, (int)i), CharSequence.class))) == StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)rhsParts, (int)i), CharSequence.class))) ? 0 : (StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)lhsParts, (int)i), CharSequence.class))) == null ? -1 : (StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)rhsParts, (int)i), CharSequence.class))) == null ? 1 : StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)lhsParts, (int)i), CharSequence.class))).compareTo(StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)rhsParts, (int)i), CharSequence.class))))))) : (lhsNumerical && !rhsNumerical ? (n3 = 1) : (!lhsNumerical && rhsNumerical ? (n2 = -1) : (n = DefaultGroovyMethods.getAt((List)lhsParts, (int)i) == DefaultGroovyMethods.getAt((List)rhsParts, (int)i) ? 0 : (DefaultGroovyMethods.getAt((List)lhsParts, (int)i) == null ? -1 : (DefaultGroovyMethods.getAt((List)rhsParts, (int)i) == null ? 1 : ((String)DefaultGroovyMethods.getAt((List)lhsParts, (int)i)).compareTo(DefaultGroovyMethods.getAt((List)rhsParts, (int)i)))))));
            if (cmp != 0) {
                return cmp;
            }
            int n5 = i;
            int cfr_ignored_0 = n5 + 1;
        }
        return ScriptBytecodeAdapter.compareTo((Object)lhsParts.size(), (Object)rhsParts.size());
    }

    private String padVersion(String base, String padValue) {
        String pad = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{padValue}, new String[]{".", EMPTY}));
        int adds = 3 - StringGroovyMethods.tokenize((CharSequence)base, (CharSequence)VERSION_SPLIT).size();
        if (adds < 0) {
            int n;
            adds = n = 0;
        }
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{base, StringGroovyMethods.multiply((CharSequence)pad, (Number)adds)}, new String[]{EMPTY, EMPTY, EMPTY}));
    }

    private String stripNonIntegerTail(String version) {
        String string = version;
        return string != null ? StringGroovyMethods.replaceFirst((CharSequence)string, (Pattern)((Pattern)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.bitwiseNegate((Object)"\\.\\p{Alpha}.*$"), Pattern.class)), (CharSequence)EMPTY) : null;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GemVersion.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GemVersion.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{EMPTY, EMPTY})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GemVersion.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{EMPTY, EMPTY})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GemVersion.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{EMPTY, EMPTY})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GemVersion.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{EMPTY, EMPTY})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GemVersion.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{EMPTY, EMPTY})));
    }

    public static /* synthetic */ Pattern pfaccess$0(GemVersion $that) {
        return (Pattern)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(GemVersion.class, GemVersion.class, (String)"ONLY_DIGITS"), Pattern.class);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        GemVersion gemVersion;
        GemVersion gemVersion2;
        String string;
        String string2;
        String string3;
        String string4;
        PAD_ZERO = string4 = "0";
        VERSION_SPLIT = string3 = ".";
        UP_IN = string2 = "]";
        LOW_IN = string = "[";
        NO_VERSION = gemVersion2 = new GemVersion(null, null, null, null);
        EVERYTHING = gemVersion = new GemVersion(Boundary.OPEN_ENDED, null, null, Boundary.OPEN_ENDED);
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"^(.+?)\\.\\+$");
        DOT_PLUS = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        Object object2 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^\\+$");
        PLUS = (Pattern)ScriptBytecodeAdapter.castToType((Object)object2, Pattern.class);
        Object object3 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^(.+?)\\.(\\p{Alnum}+)\\+$");
        DIGITS_PLUS = (Pattern)ScriptBytecodeAdapter.castToType((Object)object3, Pattern.class);
        Object object4 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^\\(,(.+)(\\[|\\])$");
        OPEN_BOTTOM = (Pattern)ScriptBytecodeAdapter.castToType((Object)object4, Pattern.class);
        Object object5 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^(\\[|\\])(.+),\\)$");
        OPEN_TOP = (Pattern)ScriptBytecodeAdapter.castToType((Object)object5, Pattern.class);
        Object object6 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^(\\[|\\])(.+?),(.+?)(\\[|\\])$");
        RANGE = (Pattern)ScriptBytecodeAdapter.castToType((Object)object6, Pattern.class);
        Object object7 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^\\d+$");
        ONLY_DIGITS = (Pattern)ScriptBytecodeAdapter.castToType((Object)object7, Pattern.class);
        Object object8 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^\\d+(\\.\\d+){1,3}(-\\p{Alnum}+)?$");
        DIGITS_AND_DOTS = (Pattern)ScriptBytecodeAdapter.castToType((Object)object8, Pattern.class);
        Object object9 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^>=\\s*(.+)");
        GREATER_EQUAL = (Pattern)ScriptBytecodeAdapter.castToType((Object)object9, Pattern.class);
        Object object10 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^>\\s*(.+)");
        GREATER = (Pattern)ScriptBytecodeAdapter.castToType((Object)object10, Pattern.class);
        Object object11 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^=\\s*(.+)");
        EQUAL = (Pattern)ScriptBytecodeAdapter.castToType((Object)object11, Pattern.class);
        Object object12 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^!=\\s*(.+)");
        NOT_EQUAL = (Pattern)ScriptBytecodeAdapter.castToType((Object)object12, Pattern.class);
        Object object13 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^<\\s*(.+)");
        LESS = (Pattern)ScriptBytecodeAdapter.castToType((Object)object13, Pattern.class);
        Object object14 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^<=\\s*(.+)");
        LESS_EQUAL = (Pattern)ScriptBytecodeAdapter.castToType((Object)object14, Pattern.class);
        Object object15 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^~>\\s*(.+)");
        TWIDDLE_WAKKA = (Pattern)ScriptBytecodeAdapter.castToType((Object)object15, Pattern.class);
        log = logger = LoggerFactory.getLogger((String)"org.ysb33r.gradle.jruby.api.gems.GemVersion");
    }

    @Generated
    public final String getLow() {
        return this.low;
    }

    @Generated
    public final String getHigh() {
        return this.high;
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "replaceAll";
        stringArray[1] = "matches";
        stringArray[2] = "getAt";
        stringArray[3] = "getAt";
        stringArray[4] = "padVersion";
        stringArray[5] = "padVersion";
        stringArray[6] = "INCLUSIVE";
        stringArray[7] = "INCLUSIVE";
        stringArray[8] = "matches";
        stringArray[9] = "INCLUSIVE";
        stringArray[10] = "OPEN_ENDED";
        stringArray[11] = "matches";
        stringArray[12] = "INCLUSIVE";
        stringArray[13] = "INCLUSIVE";
        stringArray[14] = "getAt";
        stringArray[15] = "getAt";
        stringArray[16] = "getAt";
        stringArray[17] = "getAt";
        stringArray[18] = "getAt";
        stringArray[19] = "getAt";
        stringArray[20] = "matches";
        stringArray[21] = "OPEN_ENDED";
        stringArray[22] = "getAt";
        stringArray[23] = "getAt";
        stringArray[24] = "getAt";
        stringArray[25] = "getAt";
        stringArray[26] = "INCLUSIVE";
        stringArray[27] = "EXCLUSIVE";
        stringArray[28] = "matches";
        stringArray[29] = "OPEN_ENDED";
        stringArray[30] = "getAt";
        stringArray[31] = "getAt";
        stringArray[32] = "getAt";
        stringArray[33] = "getAt";
        stringArray[34] = "INCLUSIVE";
        stringArray[35] = "EXCLUSIVE";
        stringArray[36] = "matches";
        stringArray[37] = "getAt";
        stringArray[38] = "getAt";
        stringArray[39] = "INCLUSIVE";
        stringArray[40] = "EXCLUSIVE";
        stringArray[41] = "getAt";
        stringArray[42] = "getAt";
        stringArray[43] = "INCLUSIVE";
        stringArray[44] = "EXCLUSIVE";
        stringArray[45] = "getAt";
        stringArray[46] = "getAt";
        stringArray[47] = "getAt";
        stringArray[48] = "getAt";
        stringArray[49] = "INCLUSIVE";
        stringArray[50] = "INCLUSIVE";
        stringArray[51] = "getAt";
        stringArray[52] = "getAt";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[53];
        GemVersion.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GemVersion.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GemVersion.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static final class Boundary
    extends Enum<Boundary>
    implements GroovyObject {
        public static final /* enum */ Boundary INCLUSIVE;
        public static final /* enum */ Boundary EXCLUSIVE;
        public static final /* enum */ Boundary OPEN_ENDED;
        private final String low;
        private final String high;
        public static final Boundary MIN_VALUE;
        public static final Boundary MAX_VALUE;
        private static final /* synthetic */ Boundary[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        private Boundary(String low, String hi) {
            String string;
            String string2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.low = string2 = low;
            this.high = string = hi;
        }

        @Generated
        public static final Boundary[] values() {
            return (Boundary[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), Boundary[].class);
        }

        @Generated
        public Boundary next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (Boundary)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Boundary.class);
        }

        @Generated
        public Boundary previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (Boundary)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Boundary.class);
        }

        @Generated
        public static Boundary valueOf(String name) {
            return (Boundary)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(Boundary.class, name)), Boundary.class);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Generated
        public static final /* synthetic */ Boundary $INIT(Object ... para) {
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Boundary.class)) {
                case -1409379336: {
                    return new Boundary(ShortTypeHandling.castToString((Object)objectArray[2]), ShortTypeHandling.castToString((Object)objectArray[3]));
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
        }

        static {
            Boundary boundary;
            Boundary boundary2;
            Boundary boundary3;
            Boundary boundary4;
            Boundary boundary5;
            INCLUSIVE = boundary5 = Boundary.$INIT("INCLUSIVE", 0, "[", "]");
            EXCLUSIVE = boundary4 = Boundary.$INIT("EXCLUSIVE", 1, "]", "[");
            OPEN_ENDED = boundary3 = Boundary.$INIT("OPEN_ENDED", 2, "(", ")");
            MIN_VALUE = boundary2 = INCLUSIVE;
            MAX_VALUE = boundary = OPEN_ENDED;
            Boundary[] boundaryArray = new Boundary[]{INCLUSIVE, EXCLUSIVE, OPEN_ENDED};
            $VALUES = boundaryArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Boundary.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public final String getLow() {
            return this.low;
        }

        @Generated
        public final String getHigh() {
            return this.high;
        }
    }
}

