/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.exec;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.MetaClass;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;
import org.gradle.process.ProcessForkOptions;
import org.ysb33r.grolifant.api.ClosureUtils;
import org.ysb33r.grolifant.api.StringUtils;
import org.ysb33r.grolifant.api.errors.ExecConfigurationException;
import org.ysb33r.grolifant.api.errors.ExecutionException;
import org.ysb33r.grolifant.api.exec.AbstractExecSpec;
import org.ysb33r.grolifant.api.exec.ExternalExecutable;
import org.ysb33r.grolifant.api.exec.ResolvableExecutable;

public abstract class AbstractToolExecSpec
extends AbstractExecSpec {
    private ResolvableExecutable executable;
    private final List<Object> exeArgs;
    private final List<Object> instructionArgs;
    private final ExternalExecutable executableResolver;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    protected AbstractToolExecSpec(Project project, ExternalExecutable executableResolver) {
        super(project);
        ExternalExecutable externalExecutable;
        List list;
        List list2;
        this.exeArgs = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.instructionArgs = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (executableResolver == null) {
            throw (Throwable)((Object)new ExecConfigurationException("Cannot create an execution specification without an executable resolver"));
        }
        this.executableResolver = externalExecutable = executableResolver;
    }

    public String getExecutable() {
        if (this.executable == null) {
            return ShortTypeHandling.castToString(null);
        }
        return this.executable.getExecutable().toString();
    }

    public void setExecutable(Object exe) {
        this.setExecutable(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", exe}));
    }

    public void setExecutable(ResolvableExecutable resolver) {
        ResolvableExecutable resolvableExecutable;
        this.executable = resolvableExecutable = resolver;
    }

    public void setExecutable(String exe) {
        this.setExecutable(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", exe}));
    }

    public ProcessForkOptions executable(Object exe) {
        this.setExecutable(exe);
        return this;
    }

    public ProcessForkOptions executable(ResolvableExecutable resolver) {
        ResolvableExecutable resolvableExecutable;
        this.executable = resolvableExecutable = resolver;
        return this;
    }

    public void setExecutable(Map<String, Object> exe) {
        ResolvableExecutable resolvableExecutable;
        this.executable = resolvableExecutable = this.executableResolver.getResolvableExecutable(exe);
    }

    public void executable(Map<String, Object> exe) {
        this.setExecutable(exe);
    }

    public ResolvableExecutable getResolvableExecutable() {
        return this.executable;
    }

    public List<String> getCommandLine() {
        return this.buildCommandLine();
    }

    public AbstractToolExecSpec configure(Action<? extends AbstractToolExecSpec> action) {
        action.execute((Object)this);
        return this;
    }

    public AbstractToolExecSpec configure(@DelegatesTo(value=AbstractToolExecSpec.class) Closure cfg) {
        ClosureUtils.configureItem(this, cfg);
        return this;
    }

    public void setExeArgs(Iterable<?> args) {
        this.exeArgs.clear();
        DefaultGroovyMethods.addAll(this.exeArgs, args);
    }

    public void exeArgs(Iterable<?> args) {
        DefaultGroovyMethods.addAll(this.exeArgs, args);
    }

    public void exeArgs(Object ... args) {
        DefaultGroovyMethods.addAll(this.exeArgs, (Object[])args);
    }

    public List<String> getExeArgs() {
        return StringUtils.stringize(this.exeArgs);
    }

    public ProcessForkOptions copyTo(ProcessForkOptions processForkOptions) {
        processForkOptions.setEnvironment(this.env);
        processForkOptions.setWorkingDir((Object)this.getWorkingDir());
        if (!(processForkOptions instanceof AbstractToolExecSpec) && this.executable instanceof ResolvableExecutable) {
            processForkOptions.setExecutable((Object)this.executable.getExecutable());
        } else {
            processForkOptions.setExecutable((Object)this.executable);
        }
        return this;
    }

    public void copyToExecSpec(ExecSpec execSpec) {
        this.copyTo((ProcessForkOptions)execSpec);
        OutputStream outputStream = this.getErrorOutput();
        execSpec.setErrorOutput(outputStream);
        OutputStream outputStream2 = this.getStandardOutput();
        execSpec.setStandardOutput(outputStream2);
        InputStream inputStream = this.getStandardInput();
        execSpec.setStandardInput(inputStream);
        boolean bl = this.isIgnoreExitValue();
        execSpec.setIgnoreExitValue(bl);
        execSpec.setArgs((Iterable)DefaultGroovyMethods.drop(this.buildCommandLine(), (int)1));
    }

    protected List<String> buildCommandLine() {
        List parts = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        String exe = this.getExecutable();
        if (exe == null) {
            throw (Throwable)((Object)new ExecutionException("The 'executable' part cannot be null."));
        }
        parts.add(exe);
        parts.addAll(this.getExeArgs());
        String instruction = this.getToolInstruction();
        if (instruction != null && !instruction.isEmpty()) {
            parts.add(instruction);
            parts.addAll(this.getInstructionsArgs());
        }
        return parts;
    }

    protected void setInstructionArgs(Iterable<?> args) {
        this.instructionArgs.clear();
        DefaultGroovyMethods.addAll(this.instructionArgs, args);
    }

    protected void instructionArgs(Iterable<?> args) {
        DefaultGroovyMethods.addAll(this.instructionArgs, args);
    }

    protected void instructionArgs(Object ... args) {
        DefaultGroovyMethods.addAll(this.instructionArgs, (Object[])args);
    }

    protected List<String> getInstructionsArgs() {
        return StringUtils.stringize(this.instructionArgs);
    }

    protected String getToolInstruction() {
        return ShortTypeHandling.castToString(null);
    }

    protected ExternalExecutable getExecutableResolver() {
        return this.executableResolver;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractToolExecSpec.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }
}

