/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Nullable;
import org.ysb33r.grolifant.api.os.FreeBSD;
import org.ysb33r.grolifant.api.os.GenericUnix;
import org.ysb33r.grolifant.api.os.Linux;
import org.ysb33r.grolifant.api.os.MacOsX;
import org.ysb33r.grolifant.api.os.NetBSD;
import org.ysb33r.grolifant.api.os.Solaris;
import org.ysb33r.grolifant.api.os.Windows;

public abstract class OperatingSystem
implements GroovyObject {
    protected static final String OS_NAME;
    protected static final String OS_ARCH;
    protected static final String OS_VERSION;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    protected OperatingSystem() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public boolean isWindows() {
        return false;
    }

    public boolean isMacOsX() {
        return false;
    }

    public boolean isLinux() {
        return false;
    }

    public boolean isFreeBSD() {
        return false;
    }

    public boolean isNetBSD() {
        return false;
    }

    public boolean isSolaris() {
        return false;
    }

    public boolean isUnix() {
        return false;
    }

    public String getName() {
        return OS_NAME;
    }

    public String getVersion() {
        return OS_VERSION;
    }

    public String getPathVar() {
        return "PATH";
    }

    public String getPathSeparator() {
        return File.pathSeparator;
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        String string = this.getName();
        objectArray[0] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
        String string2 = this.getVersion();
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : "";
        Arch arch = this.getArch();
        objectArray[2] = DefaultTypeTransformation.booleanUnbox((Object)((Object)arch)) ? arch : "";
        return ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"", " ", " ", ""}));
    }

    @Nullable
    public File findInPath(String name) {
        String exeName = this.getExecutableName(name);
        if (exeName.contains(this.getPathSeparator())) {
            File candidate = new File(exeName);
            if (candidate.isFile()) {
                return candidate;
            }
            return (File)ScriptBytecodeAdapter.castToType(null, File.class);
        }
        File dir = null;
        Iterator<File> iterator = this.getPath().iterator();
        while (iterator.hasNext()) {
            dir = (File)ScriptBytecodeAdapter.castToType((Object)iterator.next(), File.class);
            File candidate = new File(dir, exeName);
            if (!candidate.isFile()) continue;
            return candidate;
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public List<File> getPath() {
        List entries = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        String path = System.getenv(this.getPathVar());
        if (path != null) {
            String entry2 = null;
            String[] stringArray = path.split(Pattern.quote(this.getPathSeparator()));
            if (stringArray != null) {
                for (String entry2 : stringArray) {
                    entries.add(new File(entry2));
                }
            }
        }
        return entries;
    }

    public List<File> findAllInPath(String name) {
        List all = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        File dir = null;
        Iterator<File> iterator = this.getPath().iterator();
        while (iterator.hasNext()) {
            dir = (File)ScriptBytecodeAdapter.castToType((Object)iterator.next(), File.class);
            File candidate = new File(dir, name);
            if (!candidate.isFile()) continue;
            all.add(candidate);
        }
        return all;
    }

    public abstract String getExecutableName(String var1);

    public abstract Arch getArch();

    public abstract String getArchStr();

    public abstract String getSharedLibrarySuffix();

    public abstract String getStaticLibrarySuffix();

    public abstract String getScriptName(String var1);

    public abstract String getSharedLibraryName(String var1);

    public abstract String getStaticLibraryName(String var1);

    public static OperatingSystem current() {
        if (OS_NAME.contains("windows")) {
            return Windows.getINSTANCE();
        }
        if (OS_NAME.contains("mac os x") || OS_NAME.contains("darwin") || OS_NAME.contains("osx")) {
            return MacOsX.getINSTANCE();
        }
        if (OS_NAME.contains("linux")) {
            return Linux.getINSTANCE();
        }
        if (OS_NAME.contains("freebsd")) {
            return FreeBSD.getINSTANCE();
        }
        if (OS_NAME.contains("sunos") || OS_NAME.contains("solaris")) {
            return Solaris.getINSTANCE();
        }
        if (OS_NAME.contains("netbsd")) {
            return NetBSD.getINSTANCE();
        }
        return GenericUnix.getINSTANCE();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(OperatingSystem.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, OperatingSystem.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(OperatingSystem.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OperatingSystem.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        String string2;
        String string3;
        OS_NAME = string3 = System.getProperty("os.name").toLowerCase();
        OS_ARCH = string2 = System.getProperty("os.arch").toLowerCase();
        OS_VERSION = string = System.getProperty("os.version").toLowerCase();
    }

    public final class Arch
    extends Enum<Arch>
    implements GroovyObject {
        public static final /* enum */ Arch X86_64;
        public static final /* enum */ Arch X86;
        public static final /* enum */ Arch POWERPC;
        public static final /* enum */ Arch SPARC;
        public static final /* enum */ Arch UNKNOWN;
        private final String id;
        public static final Arch MIN_VALUE;
        public static final Arch MAX_VALUE;
        private static final /* synthetic */ Arch[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        private Arch(String id) {
            String string;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.id = string = id;
        }

        public static final Arch[] values() {
            return (Arch[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), Arch[].class);
        }

        public /* synthetic */ Arch next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (Arch)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Arch.class);
        }

        public /* synthetic */ Arch previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (Arch)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Arch.class);
        }

        public static Arch valueOf(String name) {
            return (Arch)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(Arch.class, name)), Arch.class);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final /* synthetic */ Arch $INIT(Object ... para) {
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Arch.class)) {
                case -613992018: {
                    return new Arch(ShortTypeHandling.castToString((Object)objectArray[2]));
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
        }

        static {
            Arch arch;
            Arch arch2;
            Arch arch3;
            Arch arch4;
            Arch arch5;
            Arch arch6;
            Arch arch7;
            X86_64 = arch7 = Arch.$INIT("X86_64", 0, "amd64");
            X86 = arch6 = Arch.$INIT("X86", 1, "i386");
            POWERPC = arch5 = Arch.$INIT("POWERPC", 2, "ppc");
            SPARC = arch4 = Arch.$INIT("SPARC", 3, "sparc");
            UNKNOWN = arch3 = Arch.$INIT("UNKNOWN", 4, "(unknown)");
            MIN_VALUE = arch2 = X86_64;
            MAX_VALUE = arch = UNKNOWN;
            Arch[] archArray = new Arch[]{X86_64, X86, POWERPC, SPARC, UNKNOWN};
            $VALUES = archArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Arch.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

