/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.impl;

import org.xwiki.rendering.wikimodel.WikiPageUtil;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.impl.WikiScannerContext;
import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagStack;

public class TagContext {
    private final TagContext fParent;
    private final String fName;
    private final WikiParameters fParameters;
    private final TagStack fTagStack;
    private StringBuffer fContent;
    private TagHandler fHandler;

    public TagContext(TagContext parent, String name, WikiParameters params, TagStack tagStack) {
        this.fName = name != null ? name.toLowerCase() : null;
        this.fParent = parent;
        this.fParameters = params;
        this.fTagStack = tagStack;
    }

    public boolean appendContent(String content) {
        if (this.fHandler == null || !this.fHandler.isAccumulateContent()) {
            return false;
        }
        if (this.fContent == null) {
            this.fContent = new StringBuffer();
        }
        this.fContent.append(content);
        return true;
    }

    public void beginElement(TagHandler handler) {
        if (this.fParent == null) {
            this.getScannerContext().beginDocument();
        }
        this.fHandler = handler;
        if (this.fHandler != null) {
            this.fHandler.beginElement(this);
        }
    }

    public void endElement() {
        if (this.fHandler != null) {
            this.fHandler.endElement(this);
        }
        if (this.fParent == null) {
            this.getScannerContext().endDocument();
        }
    }

    public String getContent() {
        return this.fContent != null ? WikiPageUtil.escapeXmlString(this.fContent.toString()) : "";
    }

    public String getName() {
        return this.fName;
    }

    public WikiParameters getParams() {
        return this.fParameters;
    }

    public TagContext getParentContext() {
        return this.fParent;
    }

    public TagContext getParent() {
        if (this.fParent.fHandler == null && this.fParent.fParent != null && this.fParent.fParent.fName != null) {
            return this.fParent.getParent();
        }
        return this.fParent;
    }

    public TagStack getTagStack() {
        return this.fTagStack;
    }

    public WikiScannerContext getScannerContext() {
        return this.fTagStack.getScannerContext();
    }

    public boolean isContentContainer() {
        return this.fHandler == null || this.fHandler.isContentContainer();
    }

    public boolean isTag(String string) {
        return string.equals(this.fName);
    }
}

