/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.impl.WikiScannerContext;
import org.xwiki.rendering.wikimodel.impl.WikiScannerUtil;

public class MacroInfo {
    public static final String MACRO_START = "startmacro:";
    public static final String MACRO_STOP = "stopmacro";
    private static final String MACRO_SEPARATOR = "|-|";
    private final String name;
    private WikiParameters parameters;
    private String content;
    private WikiScannerContext contentScannerContext;
    private Map<String, WikiScannerContext> parameterScannerContextMap;

    public MacroInfo(String content) {
        String macroString = content.substring(MACRO_START.length());
        int index = macroString.indexOf(MACRO_SEPARATOR);
        if (index != -1) {
            this.name = macroString.substring(0, index);
            if ((index = (macroString = macroString.substring(index + MACRO_SEPARATOR.length())).indexOf(MACRO_SEPARATOR)) != -1) {
                ArrayList<WikiParameter> parameters = new ArrayList<WikiParameter>();
                index = WikiScannerUtil.splitToPairs(macroString, parameters, null, MACRO_SEPARATOR);
                this.parameters = new WikiParameters(parameters);
                this.content = macroString.length() > index ? macroString.substring(index + MACRO_SEPARATOR.length()) : null;
            } else {
                this.parameters = WikiParameters.newWikiParameters(macroString);
                this.content = null;
            }
        } else {
            this.name = macroString;
            this.content = null;
            this.parameters = WikiParameters.EMPTY;
        }
        this.parameterScannerContextMap = new HashMap<String, WikiScannerContext>();
    }

    public String getName() {
        return this.name;
    }

    public WikiParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(WikiParameters parameters) {
        this.parameters = parameters;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public WikiScannerContext getContentScannerContext() {
        return this.contentScannerContext;
    }

    public void setContentScannerContext(WikiScannerContext contentScannerContext) {
        this.contentScannerContext = contentScannerContext;
    }

    public void setParameterScannerContext(String parameter, WikiScannerContext scannerContext) {
        this.parameterScannerContextMap.put(parameter, scannerContext);
    }

    public WikiScannerContext getParameterScannerContext(String parameter) {
        return this.parameterScannerContextMap.get(parameter);
    }
}

