/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel;

import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.IWikiPrinter;
import org.xwiki.rendering.wikimodel.ReferenceHandler;
import org.xwiki.rendering.wikimodel.WikiFormat;
import org.xwiki.rendering.wikimodel.WikiPageUtil;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;

public class PrintTextListener
implements IWemListener {
    private final IWikiPrinter fPrinter;
    protected ReferenceHandler fRefHandler;
    private boolean supportImage;
    private boolean supportDownload;

    public PrintTextListener(IWikiPrinter printer) {
        this(printer, false, false);
    }

    public PrintTextListener(IWikiPrinter printer, boolean supportImage, boolean supportDownload) {
        this.supportImage = supportImage;
        this.supportDownload = supportDownload;
        this.fPrinter = printer;
        this.fRefHandler = this.newReferenceHandler();
    }

    public boolean isSupportImage() {
        return this.supportImage;
    }

    public boolean isSupportDownload() {
        return this.supportDownload;
    }

    @Override
    public void beginDefinitionDescription() {
    }

    @Override
    public void beginDefinitionList(WikiParameters params) {
    }

    @Override
    public void beginDefinitionTerm() {
    }

    @Override
    public void beginDocument(WikiParameters params) {
    }

    @Override
    public void beginFormat(WikiFormat format) {
    }

    @Override
    public void beginHeader(int headerLevel, WikiParameters params) {
    }

    @Override
    public void beginInfoBlock(String infoType, WikiParameters params) {
    }

    @Override
    public void beginList(WikiParameters params, boolean ordered) {
    }

    @Override
    public void beginListItem() {
    }

    @Override
    public void beginListItem(WikiParameters params) {
    }

    @Override
    public void beginParagraph(WikiParameters params) {
    }

    @Override
    public void beginPropertyBlock(String propertyUri, boolean doc) {
    }

    @Override
    public void beginPropertyInline(String str) {
    }

    @Override
    public void beginQuotation(WikiParameters params) {
    }

    @Override
    public void beginQuotationLine() {
    }

    @Override
    public void beginSection(int docLevel, int headerLevel, WikiParameters params) {
    }

    @Override
    public void beginSectionContent(int docLevel, int headerLevel, WikiParameters params) {
    }

    @Override
    public void beginTable(WikiParameters params) {
    }

    @Override
    public void beginTableCell(boolean tableHead, WikiParameters params) {
    }

    @Override
    public void beginTableRow(WikiParameters params) {
    }

    protected void endBlock() {
    }

    @Override
    public void endDefinitionDescription() {
        this.endBlock();
    }

    @Override
    public void endDefinitionList(WikiParameters params) {
        this.endBlock();
    }

    @Override
    public void endDefinitionTerm() {
    }

    @Override
    public void endDocument(WikiParameters params) {
        this.endBlock();
    }

    @Override
    public void endFormat(WikiFormat format) {
    }

    @Override
    public void endHeader(int headerLevel, WikiParameters params) {
        this.endBlock();
    }

    @Override
    public void endInfoBlock(String infoType, WikiParameters params) {
        this.endBlock();
    }

    @Override
    public void endList(WikiParameters params, boolean ordered) {
        this.endBlock();
    }

    @Override
    public void endListItem() {
        this.endBlock();
    }

    @Override
    public void endListItem(WikiParameters params) {
        this.endBlock();
    }

    @Override
    public void endParagraph(WikiParameters params) {
        this.endBlock();
    }

    @Override
    public void endPropertyBlock(String propertyUri, boolean doc) {
        this.endBlock();
    }

    @Override
    public void endPropertyInline(String inlineProperty) {
    }

    @Override
    public void endQuotation(WikiParameters params) {
        this.endBlock();
    }

    @Override
    public void endQuotationLine() {
    }

    @Override
    public void endSection(int docLevel, int headerLevel, WikiParameters params) {
    }

    @Override
    public void endSectionContent(int docLevel, int headerLevel, WikiParameters params) {
    }

    @Override
    public void endTable(WikiParameters params) {
        this.endBlock();
    }

    @Override
    public void endTableCell(boolean tableHead, WikiParameters params) {
    }

    @Override
    public void endTableRow(WikiParameters params) {
    }

    protected ReferenceHandler newReferenceHandler() {
        return new ReferenceHandler(this.supportImage, this.supportDownload){

            @Override
            protected void handleImage(String ref, String label, WikiParameters params) {
                this.handleReference(ref, label, params);
            }

            @Override
            protected void handleReference(String ref, String label, WikiParameters params) {
                PrintTextListener.this.print(label);
                PrintTextListener.this.print("<" + ref + ">");
            }
        };
    }

    @Override
    public void onEmptyLines(int count) {
    }

    @Override
    public void onEscape(String str) {
        this.print(str);
    }

    @Override
    public void onExtensionBlock(String extensionName, WikiParameters params) {
    }

    @Override
    public void onExtensionInline(String extensionName, WikiParameters params) {
    }

    @Override
    public void onHorizontalLine(WikiParameters params) {
    }

    @Override
    public void onImage(String ref) {
        this.print("<img");
        this.print(" src='" + ref + "'");
        this.print(" class='wikimodel-freestanding'/>");
    }

    @Override
    public void onImage(WikiReference ref) {
        this.print("<img");
        String link = ref.getLink();
        link = WikiPageUtil.escapeXmlAttribute(link);
        this.print(" src='" + link + "'");
        WikiParameters params = ref.getParameters();
        String label = ref.getLabel();
        if (label != null && params.getParameter("title") == null) {
            params = params.addParameter("title", label);
        }
        this.print(params + "/>");
    }

    @Override
    public void onLineBreak() {
        this.println("");
    }

    @Override
    public void onMacroBlock(String macroName, WikiParameters params, String content) {
    }

    @Override
    public void onMacroInline(String macroName, WikiParameters params, String content) {
    }

    @Override
    public void onNewLine() {
        this.println("");
    }

    @Override
    public void onReference(String ref) {
        WikiReference reference = new WikiReference(ref);
        this.onReference(reference);
    }

    @Override
    public void onReference(WikiReference ref) {
        this.fRefHandler.handle(ref);
    }

    @Override
    public void onSpace(String str) {
        this.print(str);
    }

    @Override
    public void onSpecialSymbol(String str) {
        this.print(str);
    }

    @Override
    public void onTableCaption(String str) {
    }

    @Override
    public void onVerbatimBlock(String str, WikiParameters params) {
        this.print(str);
    }

    @Override
    public void onVerbatimInline(String str, WikiParameters params) {
        this.print(str);
    }

    @Override
    public void onWord(String str) {
        this.print(str);
    }

    protected void print(String str) {
        this.fPrinter.print(str);
    }

    protected void println() {
        this.fPrinter.println("");
    }

    protected void println(String str) {
        this.fPrinter.println(str);
    }
}

