/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiModelHandler;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.xhtml.handler.ImgTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagStack;

public class XWikiImageTagHandler
extends ImgTagHandler
implements XWikiWikiModelHandler {
    public void initialize(TagStack stack) {
        stack.setStackParameter("isInImage", (Object)Boolean.FALSE);
        stack.setStackParameter("isFreeStandingImage", (Object)Boolean.FALSE);
        stack.setStackParameter("imageParameters", (Object)WikiParameters.EMPTY);
    }

    protected void begin(TagContext context) {
        boolean isInImage = (Boolean)context.getTagStack().getStackParameter("isInImage");
        if (isInImage) {
            if (this.isFreeStandingReference(context)) {
                context.getTagStack().setStackParameter("isFreeStandingImage", (Object)Boolean.TRUE);
            } else {
                context.getTagStack().setStackParameter("imageParameters", (Object)this.removeMeaningfulParameters(context.getParams()));
            }
        } else {
            super.begin(context);
        }
    }

    protected void end(TagContext context) {
        WikiParameter src;
        boolean isInImage = (Boolean)context.getTagStack().getStackParameter("isInImage");
        if (!isInImage && (src = context.getParams().getParameter("src")) != null) {
            WikiParameters parameters = context.getParams().remove("src");
            if (this.isFreeStandingReference(context)) {
                context.getScannerContext().onImage(src.getValue());
            } else {
                WikiReference reference = new WikiReference(src.getValue(), null, this.removeMeaningfulParameters(parameters));
                context.getScannerContext().onImage(reference);
            }
        }
    }

    protected WikiParameters removeMeaningfulParameters(WikiParameters parameters) {
        WikiParameters result = parameters;
        if (this.containsClass(parameters, "wikigeneratedid")) {
            result = this.removeClass(parameters, "wikigeneratedid");
            result = result.remove("id");
        }
        boolean isFreeStanding = this.containsFreeStandingClass(result);
        result = this.removeFreestanding(result);
        result = result.remove("src");
        if (isFreeStanding) {
            result = result.remove("alt");
        }
        return result;
    }
}

