/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xdomxml.internal.current.parser;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.inject.Inject;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.io.SAXContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptor;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptorManager;
import org.xwiki.rendering.listener.descriptor.ListenerElement;
import org.xwiki.rendering.parser.xml.ContentHandlerStreamParser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.xdomxml.internal.current.parameter.ParameterManager;

@Component(value="xdom+xml/current")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XDOMXMLContentHandlerStreamParser
extends DefaultHandler
implements ContentHandlerStreamParser {
    private static Object[] DEFAULT_PARAMETERS = new Object[]{Listener.EMPTY_PARAMETERS};
    @Inject
    private ParameterManager parameterManager;
    @Inject
    private ListenerDescriptorManager listenerDescriptorManager;
    private ListenerDescriptor listenerDescriptor;
    private Listener listener;
    private Stack<Block> blockStack = new Stack();
    private int elementDepth = 0;
    public SAXContentHandler currentDOMBuilder = new SAXContentHandler();

    public Syntax getSyntax() {
        return Syntax.XDOMXML_CURRENT;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
        this.listenerDescriptor = this.listenerDescriptorManager.getListenerDescriptor(Listener.class);
    }

    private boolean onBlockChild() {
        if (!this.blockStack.isEmpty()) {
            Block currentBlock = this.blockStack.peek();
            return currentBlock.elementDepth == this.elementDepth - 1;
        }
        boolean result = false;
        return result;
    }

    private boolean onBlockElement(String elementName) {
        boolean result;
        if (!this.blockStack.isEmpty()) {
            Block currentBlock = this.blockStack.peek();
            result = this.elementDepth - currentBlock.elementDepth <= 1 && "block".equals(elementName);
        } else {
            result = true;
        }
        return result;
    }

    private boolean onParameterElement(String elementName) {
        return this.onBlockChild() && "parameter".equals(elementName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Block currentBlock;
        Block block = currentBlock = this.blockStack.isEmpty() ? null : this.blockStack.peek();
        if (this.onBlockElement(qName)) {
            if (currentBlock != null && currentBlock.listenerElement != null && !currentBlock.beginSent) {
                currentBlock.fireBeginEvent(this.listener, currentBlock.getParametersTable());
            }
            Block block2 = this.getBlock(uri, localName, qName, attributes);
            currentBlock = this.blockStack.push(block2);
        } else {
            if (this.onParameterElement(qName) && currentBlock.listenerElement != null) {
                currentBlock.parameterDOMBuilder = this.currentDOMBuilder;
                currentBlock.parameterDOMBuilder.startDocument();
            }
            if (currentBlock.parameterDOMBuilder != null) {
                currentBlock.parameterDOMBuilder.startElement(uri, localName, qName, attributes);
            }
        }
        ++this.elementDepth;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Block currentBlock = this.blockStack.isEmpty() ? null : this.blockStack.peek();
        --this.elementDepth;
        if (this.onBlockElement(qName)) {
            Block block = this.blockStack.pop();
            if (block.listenerElement != null) {
                if (block.isContainer()) {
                    if (!block.beginSent) {
                        block.fireBeginEvent(this.listener, block.getParametersTable());
                    }
                    block.fireEndEvent(this.listener, block.getParametersTable());
                } else {
                    block.fireOnEvent(this.listener, block.getParametersTable());
                }
            }
        } else if (currentBlock.parameterDOMBuilder != null) {
            currentBlock.parameterDOMBuilder.endElement(uri, localName, qName);
            if (this.onParameterElement(qName)) {
                if (currentBlock.listenerElement != null) {
                    currentBlock.parameterDOMBuilder.endDocument();
                    ListenerElement listenerElement = currentBlock.listenerElement;
                    Type parameterType = (Type)listenerElement.getParameters().get(currentBlock.parametersList.size());
                    Element rootElement = currentBlock.parameterDOMBuilder.getDocument().getRootElement();
                    Attribute nullAttribute = rootElement.attribute("null");
                    if (nullAttribute != null && "true".equals(nullAttribute.getValue())) {
                        currentBlock.addParameter(null);
                    } else {
                        currentBlock.addParameter(this.parameterManager.unSerialize(parameterType, rootElement));
                    }
                }
                currentBlock.parameterDOMBuilder = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.blockStack.isEmpty() && this.blockStack.peek().parameterDOMBuilder != null) {
            this.blockStack.peek().parameterDOMBuilder.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.blockStack.isEmpty() && this.blockStack.peek().parameterDOMBuilder != null) {
            this.blockStack.peek().parameterDOMBuilder.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (!this.blockStack.isEmpty() && this.blockStack.peek().parameterDOMBuilder != null) {
            this.blockStack.peek().parameterDOMBuilder.skippedEntity(name);
        }
    }

    private Block getBlock(String uri, String localName, String qName, Attributes attributes) {
        String name = attributes.getValue("name");
        ListenerElement element = (ListenerElement)this.listenerDescriptor.getElements().get(name.toLowerCase());
        return new Block(element, this.elementDepth);
    }

    public static class Block {
        public ListenerElement listenerElement;
        public boolean beginSent = false;
        public List<Object> parametersList = new ArrayList<Object>();
        public SAXContentHandler parameterDOMBuilder;
        public int elementDepth;
        private Object[] parametersTable;

        public Block(ListenerElement listenerElement, int elementDepth) {
            this.listenerElement = listenerElement;
            this.elementDepth = elementDepth;
        }

        public boolean isContainer() {
            return this.listenerElement.getOnMethod() == null;
        }

        public void addParameter(Object parameter) {
            this.parametersList.add(parameter);
            this.parametersTable = null;
        }

        public Object[] getParametersTable() {
            if (this.parametersTable == null) {
                if (this.parametersList.isEmpty()) {
                    this.parametersTable = DEFAULT_PARAMETERS;
                }
                this.parametersTable = this.parametersList.toArray();
            }
            return this.parametersTable;
        }

        public void fireBeginEvent(Listener listener, Object[] parameters) throws SAXException {
            this.fireEvent(this.listenerElement.getBeginMethod(), listener, parameters);
            this.beginSent = true;
        }

        public void fireEndEvent(Listener listener, Object[] parameters) throws SAXException {
            this.fireEvent(this.listenerElement.getEndMethod(), listener, parameters);
        }

        public void fireOnEvent(Listener listener, Object[] parameters) throws SAXException {
            this.fireEvent(this.listenerElement.getOnMethod(), listener, parameters);
        }

        private void fireEvent(Method eventMethod, Listener listener, Object[] parameters) throws SAXException {
            try {
                eventMethod.invoke((Object)listener, parameters);
            }
            catch (Exception e) {
                throw new SAXException("Failed to invoke event [" + eventMethod + "]", e);
            }
        }
    }
}

