/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.link;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;

@Component
@Named(value="annotated")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class AnnotatedXHTMLLinkRenderer
implements XHTMLLinkRenderer {
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceSerializer xhtmlMarkerSerializer;
    @Inject
    private XHTMLLinkRenderer defaultLinkRenderer;

    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.defaultLinkRenderer.setXHTMLWikiPrinter(printer);
    }

    public void setHasLabel(boolean hasLabel) {
        this.defaultLinkRenderer.setHasLabel(hasLabel);
    }

    public void beginLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder("startwikilink:");
        builder.append(this.xhtmlMarkerSerializer.serialize(reference));
        this.getXHTMLWikiPrinter().printXMLComment(builder.toString(), true);
        this.defaultLinkRenderer.beginLink(reference, freestanding, parameters);
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.defaultLinkRenderer.endLink(reference, freestanding, parameters);
        this.getXHTMLWikiPrinter().printXMLComment("stopwikilink");
    }

    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.defaultLinkRenderer.getXHTMLWikiPrinter();
    }
}

