/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParametersPrinter {
    private static final String QUOTE = "\"";
    private final String escapedStrings;
    private char escapeChar;
    private Pattern escaped;
    private String replacement;

    @Deprecated
    public ParametersPrinter() {
        this.escapedStrings = Pattern.quote(QUOTE);
    }

    public ParametersPrinter(char escapeChar, String ... escapedStrings) {
        StringBuilder builder = new StringBuilder();
        builder.append(Pattern.quote(QUOTE));
        for (String str : escapedStrings) {
            builder.append('|');
            builder.append(Pattern.quote(str));
        }
        this.escapedStrings = builder.toString();
        this.setEscapeChar(escapeChar);
    }

    private void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
        StringBuilder replacementBuilder = new StringBuilder();
        replacementBuilder.append(Matcher.quoteReplacement(String.valueOf(escapeChar)));
        replacementBuilder.append("$0");
        this.replacement = replacementBuilder.toString();
        this.escaped = Pattern.compile(Pattern.quote(String.valueOf(this.escapeChar)) + '|' + this.escapedStrings);
    }

    @Deprecated
    public String print(Map<String, String> parameters, char escapeChar) {
        this.escapeChar = escapeChar;
        return this.print(parameters);
    }

    public String print(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (key == null || value == null) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(this.print(key, value));
        }
        return builder.toString();
    }

    public String print(String parameterName, String parameterValue, char escapeChar) {
        this.escapeChar = escapeChar;
        return this.print(parameterName, parameterValue);
    }

    public String print(String parameterName, String parameterValue) {
        String value = this.escaped.matcher(parameterValue).replaceAll(this.replacement);
        return parameterName + "=" + QUOTE + value + QUOTE;
    }
}

