/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.block.AbstractBlock;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;

public class MetaDataBlock
extends AbstractBlock {
    private MetaData metaData;

    public MetaDataBlock(List<? extends Block> childBlocks, MetaData metaData) {
        super(childBlocks);
        this.metaData = metaData;
    }

    public MetaDataBlock(List<? extends Block> childBlocks, String key, Object value) {
        this(childBlocks, new MetaData(Collections.singletonMap(key, value)));
    }

    public MetaDataBlock(List<? extends Block> childBlocks) {
        this(childBlocks, new MetaData());
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void before(Listener listener) {
        listener.beginMetaData(this.getMetaData());
    }

    @Override
    public void after(Listener listener) {
        listener.endMetaData(this.getMetaData());
    }

    @Override
    public MetaDataBlock clone() {
        MetaDataBlock cloned = (MetaDataBlock)super.clone();
        cloned.metaData = new MetaData(this.metaData.getMetaData());
        return cloned;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MetaDataBlock && super.equals(obj)) {
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getMetaData(), (Object)((MetaDataBlock)obj).getMetaData());
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append((Object)this.getMetaData());
        return builder.toHashCode();
    }
}

