/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.internal.wiki;

import javax.inject.Inject;
import javax.inject.Provider;

import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.wiki.WikiModel;

/**
 * Used to find out if an implementation of {@link WikiModel} is available or not at runtime. In non wiki mode all
 * image and link references are considered as URLs or Paths.
 *
 * @version $Id: f42946a71cdbdeb8a70726759fed5df053600b73 $
 * @since 5.2M1
 */
public class WikiModelProvider implements Provider<WikiModel>
{
    /**
     * Used to verify if we're in wiki mode or not by looking up an implementation of
     * {@link org.xwiki.rendering.wiki.WikiModel}. In non wiki mode all image references are considered as URLs.
     */
    @Inject
    private ComponentManager componentManager;

    @Override
    public WikiModel get()
    {
        WikiModel wikiModel;
        try {
            wikiModel = this.componentManager.getInstance(WikiModel.class);
        } catch (ComponentLookupException e) {
            wikiModel = null;
        }
        return wikiModel;
    }
}
