/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser;

import java.io.Reader;
import javax.inject.Inject;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.XDOMGeneratorListener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.StreamParser;

public abstract class AbstractBlockParser
implements Parser {
    @Inject
    private ComponentManager componentManager;

    protected StreamParser getStreamParser() {
        StreamParser streamParser;
        try {
            streamParser = (StreamParser)this.componentManager.lookup(StreamParser.class, this.getSyntax().toIdString());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to create [" + this.getSyntax().toString() + "] renderer", e);
        }
        return streamParser;
    }

    @Override
    public XDOM parse(Reader source) throws ParseException {
        XDOMGeneratorListener listener = new XDOMGeneratorListener();
        this.getStreamParser().parse(source, listener);
        return listener.getXDOM();
    }
}

