/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.reference;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.reference.AbstractResourceReferenceParser;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceTypeParser;

@Component
@Singleton
public class DefaultResourceReferenceParser
extends AbstractResourceReferenceParser {
    public static final char TYPE_SEPARATOR = ':';
    private static final List<ResourceType> WIKI_REFERENCE_TYPES = Arrays.asList(ResourceType.DOCUMENT, ResourceType.SPACE, ResourceType.PAGE, ResourceType.ATTACHMENT, ResourceType.PAGE_ATTACHMENT, ResourceType.ICON);
    @Inject
    private Logger logger;

    @Override
    public ResourceReference parse(String rawReference) {
        ResourceReference parsedResourceReference = null;
        int pos = rawReference.indexOf(58);
        if (pos > -1) {
            String typePrefix = rawReference.substring(0, pos);
            String reference = rawReference.substring(pos + 1);
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            if (componentManager.hasComponent(ResourceReferenceTypeParser.class, typePrefix)) {
                try {
                    ResourceReferenceTypeParser parser = (ResourceReferenceTypeParser)componentManager.getInstance(ResourceReferenceTypeParser.class, typePrefix);
                    parsedResourceReference = parser.parse(reference);
                }
                catch (ComponentLookupException e) {
                    this.logger.error("Failed to initialize resource type parser", (Throwable)e);
                }
            }
        }
        if (parsedResourceReference == null) {
            parsedResourceReference = new ResourceReference(rawReference, ResourceType.UNKNOWN);
        }
        if (!this.isInWikiMode() && WIKI_REFERENCE_TYPES.contains(parsedResourceReference.getType())) {
            parsedResourceReference = new ResourceReference(rawReference, ResourceType.URL);
            parsedResourceReference.setTyped(false);
        }
        return parsedResourceReference;
    }
}

