/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.listener.descriptor;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptor;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptorManager;
import org.xwiki.rendering.listener.descriptor.ListenerElement;

@Component
@Singleton
public class DefaultListenerDescriptorManager
implements ListenerDescriptorManager {
    private static final String PREFIX_BEGIN = "begin";
    private static final String PREFIX_END = "end";
    private static final String PREFIX_ON = "on";
    private Map<Class<?>, ListenerDescriptor> descriptors = new ConcurrentHashMap();

    @Override
    public ListenerDescriptor getListenerDescriptor(Class<?> type) {
        ListenerDescriptor descriptor = this.descriptors.get(type);
        if (descriptor == null) {
            descriptor = this.createDescriptor(type);
            this.descriptors.put(type, descriptor);
        }
        return descriptor;
    }

    public ListenerDescriptor createDescriptor(Class<?> type) {
        ListenerDescriptor descriptor = new ListenerDescriptor();
        for (Method method : ReflectionUtils.getTypeClass(type).getMethods()) {
            String methodName = method.getName();
            Object elementName = methodName.startsWith(PREFIX_BEGIN) ? methodName.substring(PREFIX_BEGIN.length(), methodName.length()) : (methodName.startsWith(PREFIX_END) ? methodName.substring(PREFIX_END.length(), methodName.length()) : (methodName.startsWith(PREFIX_ON) ? methodName.substring(PREFIX_ON.length(), methodName.length()) : null));
            if (elementName == null) continue;
            elementName = Character.toLowerCase(((String)elementName).charAt(0)) + ((String)elementName).substring(1, ((String)elementName).length());
            this.addElement((String)elementName, descriptor, method);
        }
        return descriptor;
    }

    private void addElement(String elementName, ListenerDescriptor descriptor, Method method) {
        String lowerElementName = elementName.toLowerCase(Locale.ROOT);
        ListenerElement element = descriptor.getElements().get(lowerElementName);
        Type[] methodTypes = method.getGenericParameterTypes();
        if (element == null || methodTypes.length > element.getParameters().size()) {
            element = new ListenerElement(elementName);
            element.getParameters().clear();
            for (Type parameterType : method.getGenericParameterTypes()) {
                element.getParameters().add(parameterType);
            }
            descriptor.getElements().put(lowerElementName, element);
        }
        this.addMethod(element, method);
    }

    private void addMethod(ListenerElement element, Method method) {
        String methodName = method.getName();
        Type[] methodTypes = method.getGenericParameterTypes();
        if (methodName.startsWith(PREFIX_BEGIN)) {
            if (element.getBeginMethod() == null || element.getBeginMethod().getGenericParameterTypes().length < methodTypes.length) {
                element.setBeginMethod(method);
            }
        } else if (methodName.startsWith(PREFIX_END)) {
            if (element.getEndMethod() == null || element.getEndMethod().getGenericParameterTypes().length < methodTypes.length) {
                element.setEndMethod(method);
            }
        } else if (element.getOnMethod() == null || element.getOnMethod().getGenericParameterTypes().length < methodTypes.length) {
            element.setOnMethod(method);
        }
    }
}

