/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.provider.Arguments;
import org.mockito.Mockito;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;

public class ListenerMethodProvider {
    public static Stream<Arguments> beginEndMethodsProvider() {
        return Arrays.stream(Listener.class.getMethods()).filter(m -> m.getName().startsWith("begin")).map(m -> {
            String endMethodName = m.getName().replace("begin", "end");
            Method endMethod = null;
            try {
                endMethod = Listener.class.getMethod(endMethodName, m.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                Assertions.fail((String)("Expected end method " + endMethodName + " for " + m.getName() + " not found: " + e.getMessage()));
            }
            return Arguments.arguments((Object[])new Object[]{Named.of((String)ListenerMethodProvider.getTestName(m), (Object)m), Named.of((String)ListenerMethodProvider.getTestName(endMethod), (Object)endMethod), ListenerMethodProvider.getMockParameters(m)});
        });
    }

    public static Stream<Arguments> onMethodsProvider() {
        return Arrays.stream(Listener.class.getMethods()).filter(m -> m.getName().startsWith("on")).map(m -> Arguments.arguments((Object[])new Object[]{Named.of((String)ListenerMethodProvider.getTestName(m), (Object)m), ListenerMethodProvider.getMockParameters(m)}));
    }

    public static Stream<Arguments> allMethodsProvider() {
        return Arrays.stream(Listener.class.getMethods()).map(m -> Arguments.arguments((Object[])new Object[]{Named.of((String)ListenerMethodProvider.getTestName(m), (Object)m), ListenerMethodProvider.getMockParameters(m)}));
    }

    private static String getTestName(Method method) {
        return method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(", ")) + ")";
    }

    private static Object getMockParameters(Method method) {
        return Arrays.stream(method.getParameterTypes()).map(ListenerMethodProvider::mockParameter).toArray();
    }

    private static Object mockParameter(Class<?> classToMock) {
        if (classToMock.equals(Format.class)) {
            return Format.BOLD;
        }
        if (classToMock.equals(ListType.class)) {
            return ListType.BULLETED;
        }
        if (classToMock.equals(HeaderLevel.class)) {
            return HeaderLevel.LEVEL1;
        }
        if (classToMock.equals(String.class)) {
            return "Mock";
        }
        if (classToMock.equals(Boolean.TYPE)) {
            return true;
        }
        if (classToMock.equals(Character.TYPE)) {
            return Character.valueOf('{');
        }
        if (classToMock.equals(Integer.TYPE)) {
            return 42;
        }
        return Mockito.mock(classToMock);
    }
}

