/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.syntax;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxRegistry;

@Component
@Singleton
@Named(value="syntaxregistry")
public class SyntaxRegistryListener
implements EventListener {
    private static final Type SYNTAX_PROVIDER_TYPE = new DefaultParameterizedType(null, Provider.class, new Type[]{new DefaultParameterizedType(null, List.class, new Type[]{Syntax.class})});
    @Inject
    private SyntaxRegistry syntaxRegistry;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    private Map<ComponentDescriptor<?>, Syntax[]> componentSyntaxes = new HashMap();

    public String getName() {
        return "syntaxregistry";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new ApplicationStartedEvent(), new ComponentDescriptorAddedEvent(SYNTAX_PROVIDER_TYPE), new ComponentDescriptorRemovedEvent(SYNTAX_PROVIDER_TYPE));
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof ApplicationStartedEvent) {
            this.registerSyntaxesProviders();
        } else {
            ComponentManager componentManager = (ComponentManager)source;
            ComponentDescriptor descriptor = (ComponentDescriptor)data;
            if (event instanceof ComponentDescriptorAddedEvent) {
                Provider<List<Syntax>> syntaxesProvider = this.getSyntaxesProvider(componentManager, descriptor);
                List syntaxes = (List)syntaxesProvider.get();
                Syntax[] syntaxArray = new Syntax[syntaxes.size()];
                this.syntaxRegistry.registerSyntaxes(syntaxes.toArray(syntaxArray));
                this.componentSyntaxes.put(descriptor, syntaxArray);
            } else if (this.componentSyntaxes.containsKey(descriptor)) {
                this.syntaxRegistry.unregisterSyntaxes(this.componentSyntaxes.get(descriptor));
            }
        }
    }

    private void registerSyntaxesProviders() {
        ComponentManager cm = (ComponentManager)this.componentManagerProvider.get();
        List componentDescriptors = cm.getComponentDescriptorList(SYNTAX_PROVIDER_TYPE);
        for (ComponentDescriptor cd : componentDescriptors) {
            Provider syntaxesProvider;
            try {
                syntaxesProvider = (Provider)cm.getInstance(cd.getRoleType(), cd.getRoleHint());
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(String.format("Failed to instantiate Syntax Provider component [{}]", cd), e);
            }
            this.registerSyntaxesProvider((Provider<List<Syntax>>)syntaxesProvider, cd);
        }
    }

    private void registerSyntaxesProvider(Provider<List<Syntax>> syntaxesProvider, ComponentDescriptor<?> descriptor) {
        List syntaxes = (List)syntaxesProvider.get();
        Syntax[] syntaxArray = new Syntax[syntaxes.size()];
        this.syntaxRegistry.registerSyntaxes(syntaxes.toArray(syntaxArray));
        this.componentSyntaxes.put(descriptor, syntaxArray);
    }

    private Provider<List<Syntax>> getSyntaxesProvider(ComponentManager componentManager, ComponentDescriptor<?> descriptor) {
        try {
            return (Provider)componentManager.getInstance(SYNTAX_PROVIDER_TYPE, descriptor.getRoleHint());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(String.format("Failed to lookup Syntaxes Provider for role [%s]", descriptor.getRoleHint()), e);
        }
    }
}

