/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.block.AbstractBlock;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.reference.ResourceReference;

public class LinkBlock
extends AbstractBlock {
    private ResourceReference reference;
    private boolean freestanding;

    public LinkBlock(List<Block> childrenBlocks, ResourceReference reference, boolean freestanding) {
        this(childrenBlocks, reference, freestanding, Collections.emptyMap());
    }

    public LinkBlock(List<Block> childrenBlocks, ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        super(childrenBlocks, parameters);
        this.reference = reference;
        this.freestanding = freestanding;
    }

    public ResourceReference getReference() {
        return this.reference;
    }

    public boolean isFreeStandingURI() {
        return this.freestanding;
    }

    @Override
    public void before(Listener listener) {
        listener.beginLink(this.getReference(), this.isFreeStandingURI(), this.getParameters());
    }

    @Override
    public void after(Listener listener) {
        listener.endLink(this.getReference(), this.isFreeStandingURI(), this.getParameters());
    }

    @Override
    public LinkBlock clone(BlockFilter blockFilter) {
        LinkBlock clone = (LinkBlock)super.clone(blockFilter);
        clone.reference = this.getReference().clone();
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LinkBlock && super.equals(obj)) {
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getReference(), (Object)((LinkBlock)obj).getReference());
            builder.append(this.isFreeStandingURI(), ((LinkBlock)obj).isFreeStandingURI());
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append((Object)this.getReference());
        builder.append(this.isFreeStandingURI());
        return builder.toHashCode();
    }
}

