/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.listener;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MetaData {
    public static final MetaData EMPTY = new MetaData();
    public static final String SOURCE = "source";
    public static final String SYNTAX = "syntax";
    public static final String BASE = "base";
    public static final String NON_GENERATED_CONTENT = "non-generated-content";
    public static final String PARAMETER_NAME = "parameter-name";
    private final Map<String, Object> metadata;

    public MetaData() {
        this.metadata = new LinkedHashMap<String, Object>();
    }

    public MetaData(Map<String, Object> metaData) {
        this.metadata = new LinkedHashMap<String, Object>(metaData);
    }

    public void addMetaData(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void addMetaData(MetaData metaData) {
        this.metadata.putAll(metaData.getMetaData());
    }

    public Object getMetaData(String key) {
        return this.metadata.get(key);
    }

    public boolean contains(String key) {
        return this.metadata.containsKey(key);
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof MetaData && this.metadata.equals(((MetaData)obj).metadata);
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    public String toString() {
        return "MetaData{metadata=" + this.metadata + '}';
    }
}

