/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;

public class XDOMBuilder {
    private Deque<List<Block>> stack = new ArrayDeque<List<Block>>();

    public XDOMBuilder() {
        this.startBlockList();
    }

    public XDOM getXDOM() {
        List<Block> blocks = this.endBlockList();
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("Unbalanced begin/end Block events, missing " + this.stack.size() + " calls to endBlockList().");
        }
        if (!blocks.isEmpty() && blocks.get(0) instanceof XDOM) {
            return (XDOM)blocks.get(0);
        }
        return new XDOM(blocks);
    }

    public void startBlockList() {
        this.stack.push(new ArrayList());
    }

    public List<Block> endBlockList() {
        try {
            return this.stack.pop();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Unbalanced begin/end Block events, too many calls to endBlockList().");
        }
    }

    public void addBlock(Block block) {
        try {
            this.stack.getFirst().add(block);
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("All container blocks are closed, too many calls to endBlockList().");
        }
    }
}

