/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer;

import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

public abstract class AbstractBlockRenderer
implements BlockRenderer {
    @Inject
    protected Logger logger;

    protected abstract PrintRendererFactory getPrintRendererFactory();

    @Override
    public void render(Block block, WikiPrinter printer) {
        this.render(Collections.singletonList(block), printer);
    }

    @Override
    public void render(Collection<Block> blocks, WikiPrinter printer) {
        block4: {
            PrintRenderer renderer = this.getPrintRendererFactory().createRenderer(printer);
            for (Block block : blocks) {
                block.traverse(renderer);
            }
            if (renderer instanceof Flushable) {
                try {
                    ((Flushable)((Object)renderer)).flush();
                }
                catch (IOException e) {
                    if (this.logger == null) break block4;
                    this.logger.error("Failed to flush renderer [{}]", (Object)renderer, (Object)e);
                }
            }
        }
    }
}

