/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.inject.Singleton;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.EntityResolver;
import org.xwiki.xml.internal.AgentUtil;

@Component
@Singleton
public class LocalEntityResolver
implements EntityResolver,
EntityResolver2 {
    private static final DTDLoader dtdLoader = LocalEntityResolver.createDTDLoader();
    private static final String XHTML1_TRA_PUBLICID = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    private static final String XHTML1_TRA_SYSTEMID = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private final HashMap<String, String> systemIdToFilename = new HashMap(69, 0.4f);
    private final HashMap<String, String> systemIdToPublicId = new HashMap(14);
    private ClassLoader loader = null;
    private HashSet<String> whitelist = null;

    public LocalEntityResolver() {
        this(true);
    }

    public LocalEntityResolver(boolean enableWhitelist) {
        this.systemIdToFilename.put("https://www.w3.org/TR/html5/entities.dtd", "/xhtml5.ent");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", "/xhtml1-strict.dtd");
        this.systemIdToFilename.put(XHTML1_TRA_SYSTEMID, "/xhtml1-transitional.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", "/xhtml11.dtd");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml11.dtd", "/xhtml11.dtd");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-lat1.ent", "/xhtml5.ent");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-lat1.ent", "/xhtml5.ent");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-symbol.ent", "/xhtml-symbol.ent");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-symbol.ent", "/xhtml-symbol.ent");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-special.ent", "/xhtml-special.ent");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-special.ent", "/xhtml-special.ent");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inlstyle-1.mod", "/xhtml-inlstyle-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml11-model-1.mod", "/xhtml11-model-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-datatypes-1.mod", "/xhtml-datatypes-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-framework-1.mod", "/xhtml-framework-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-text-1.mod", "/xhtml-text-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-hypertext-1.mod", "/xhtml-hypertext-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-list-1.mod", "/xhtml-list-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-edit-1.mod", "/xhtml-edit-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-bdo-1.mod", "/xhtml-bdo-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-ruby-1.mod", "/xhtml-ruby-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-pres-1.mod", "/xhtml-pres-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-link-1.mod", "/xhtml-link-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-meta-1.mod", "/xhtml-meta-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-base-1.mod", "/xhtml-base-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-script-1.mod", "/xhtml-script-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-style-1.mod", "/xhtml-style-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-image-1.mod", "/xhtml-image-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-csismap-1.mod", "/xhtml-csismap-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-ssismap-1.mod", "/xhtml-ssismap-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-param-1.mod", "/xhtml-param-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-object-1.mod", "/xhtml-object-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-table-1.mod", "/xhtml-table-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-form-1.mod", "/xhtml-form-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-legacy-1.mod", "/xhtml-legacy-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-struct-1.mod", "/xhtml-struct-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", "/xhtml1-frameset.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd", "/xhtml-basic11.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/html4/strict.dtd", "/html4-strict.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/html4/loose.dtd", "/html4-loose.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/html4/frameset.dtd", "/html4-frameset.dtd");
        this.systemIdToFilename.put("http://www.w3.org/Math/DTD/mathml2/mathml2.dtd", "/mathml2.dtd");
        this.systemIdToFilename.put("http://www.w3.org/Math/DTD/mathml1/mathml.dtd", "/mathml.dtd");
        this.systemIdToFilename.put("http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd", "/xhtml-math-svg.dtd");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inlstruct-1.mod", "/xhtml-inlstruct-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inlphras-1.mod", "/xhtml-inlphras-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-blkstruct-1.mod", "/xhtml-blkstruct-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-blkphras-1.mod", "/xhtml-blkphras-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-applet-1.mod", "/xhtml-applet-1.dtd");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-blkpres-1.mod", "/xhtml-blkpres-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-basic-form-1.mod", "/xhtml-basic-form-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-basic-table-1.mod", "/xhtml-basic-table-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-frames-1.mod", "/xhtml-frames-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-target-1.mod", "/xhtml-target-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-iframe-1.mod", "/xhtml-iframe-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-events-1.mod", "/xhtml-events-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-nameident-1.mod", "/xhtml-nameident-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-legacy-redecl-1.mod", "/xhtml-legacy-redecl-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inlpres-1.mod", "/xhtml-inlpres-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-arch-1.mod", "/xhtml-arch-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-notations-1.mod", "/xhtml-notations-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-qname-1.mod", "/xhtml-qname-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-attribs-1.mod", "/xhtml-attribs-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-charent-1.mod", "/xhtml-charent-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-basic11-model-1.mod", "/xhtml-basic11-model-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inputmode-1.mod", "/xhtml-inputmode-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", "/svg11.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd", "/svg10.dtd");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", "-//W3C//DTD XHTML 1.0 Strict//EN");
        this.systemIdToPublicId.put(XHTML1_TRA_SYSTEMID, XHTML1_TRA_PUBLICID);
        this.systemIdToPublicId.put("http://www.w3.org/MarkUp/DTD/xhtml11.dtd", "-//W3C//DTD XHTML 1.1//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-lat1.ent", "-//W3C//ENTITIES Latin 1 for XHTML//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-symbol.ent", "-//W3C//ENTITIES Symbols for XHTML//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-special.ent", "-//W3C//ENTITIES Special for XHTML//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/html4/strict.dtd", "-//W3C//DTD HTML 4.01//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/html4/loose.dtd", "-//W3C//DTD HTML 4.01 Transitional//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/html4/frameset.dtd", "-//W3C//DTD HTML 4.01 Frameset//EN");
        this.systemIdToPublicId.put("http://www.w3.org/Math/DTD/mathml2/mathml2.dtd", "-//W3C//DTD MathML 2.0//EN");
        this.systemIdToPublicId.put("http://www.w3.org/Math/DTD/mathml1/mathml.dtd", "math");
        this.systemIdToPublicId.put("http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd", "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN");
        this.systemIdToPublicId.put("http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", "-//W3C//DTD SVG 1.1//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd", "-//W3C//DTD SVG 1.0//EN");
        if (enableWhitelist) {
            this.whitelist = new HashSet(1);
        }
    }

    public void addHostToWhiteList(String fqdn) {
        if (fqdn != null) {
            if (this.whitelist == null) {
                this.whitelist = new HashSet(4);
            }
            this.whitelist.add(fqdn.toLowerCase(Locale.ROOT));
        }
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        InputSource is = this.findExternalSubset(name, baseURI);
        if (is == null) {
            String fname = this.systemIdToFilename.get("https://www.w3.org/TR/html5/entities.dtd");
            Reader re = dtdLoader.loadDTDfromClasspath(this.loader, fname);
            if (re != null) {
                is = new InputSource(re);
            } else {
                throw new IOException("Could not find resource: " + fname);
            }
        }
        return is;
    }

    private InputSource findExternalSubset(String name, String baseURI) throws SAXException, IOException {
        InputSource is;
        if ("html".equalsIgnoreCase(name)) {
            is = this.resolveEntity("[dtd]", XHTML1_TRA_PUBLICID, baseURI, XHTML1_TRA_SYSTEMID);
            is.setPublicId(null);
            is.setSystemId(null);
        } else {
            is = null;
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean registerSystemIdFilename(String systemId, String filename) {
        String ret;
        if (filename == null || systemId == null) {
            throw new NullPointerException("Null SystemId or filename.");
        }
        if (this.isInvalidPath(filename)) {
            throw new IllegalArgumentException("Bad DTD filename.");
        }
        HashMap<String, String> hashMap = this.systemIdToFilename;
        synchronized (hashMap) {
            ret = this.systemIdToFilename.putIfAbsent(systemId, filename);
        }
        return ret == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (publicId == null) {
            publicId = this.systemIdToPublicId.get(systemId);
        } else if (systemId == null) {
            systemId = this.getSystemIdFromPublicId(publicId);
        }
        String fname = this.systemIdToFilename.get(systemId);
        InputSource isrc = null;
        if (fname != null) {
            Reader re = dtdLoader.loadDTDfromClasspath(this.loader, fname);
            if (re == null) throw new SAXException("Could not find resource: " + fname);
            isrc = new InputSource(re);
            isrc.setPublicId(publicId);
            if (systemId == null) return isrc;
            isrc.setSystemId(systemId);
            return isrc;
        } else {
            int sepidx;
            URL enturl;
            if (systemId == null) return this.findExternalSubset(name, baseURI);
            if (baseURI != null) {
                URL base = new URL(baseURI);
                enturl = new URL(base, systemId);
            } else {
                enturl = new URL(systemId);
            }
            if (this.isInvalidProtocol(enturl.getProtocol())) {
                throw new SAXException("Invalid url protocol: " + enturl.getProtocol());
            }
            if (this.isWhitelistEnabled() && !this.isWhitelistedHost(enturl.getHost())) {
                throw new SAXException("Whitelist is enabled, and attempted to retrieve data from " + enturl.toExternalForm());
            }
            boolean invalidPath = this.isInvalidPath(enturl.getPath());
            String charset = "UTF-8";
            URLConnection con = this.openConnection(enturl);
            this.connect(con);
            String conType = con.getContentType();
            if (conType != null && (sepidx = conType.indexOf(59)) != -1 && sepidx < conType.length()) {
                conType = conType.substring(0, sepidx);
                charset = AgentUtil.findCharset(conType, sepidx + 1);
            }
            if (invalidPath && !this.isValidContentType(conType)) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                Object msg = enturl.toExternalForm();
                if (conType != null) {
                    conType = conType.replaceAll("\\p{Cc}", "*CTRL*");
                    msg = "URL served with invalid type (" + conType + "): " + (String)msg;
                    throw new SAXException((String)msg);
                } else {
                    msg = "URL served with invalid type: " + (String)msg;
                }
                throw new SAXException((String)msg);
            }
            isrc = new InputSource();
            isrc.setSystemId(enturl.toExternalForm());
            if (publicId != null) {
                isrc.setPublicId(publicId);
            }
            isrc.setEncoding(charset);
            InputStream is = con.getInputStream();
            isrc.setCharacterStream(new InputStreamReader(is, charset));
        }
        return isrc;
    }

    private String getSystemIdFromPublicId(String publicId) {
        for (Map.Entry<String, String> entry : this.systemIdToPublicId.entrySet()) {
            if (!publicId.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    protected boolean isInvalidPath(String path) {
        String ext;
        int len = path.length();
        return len < 5 || !(ext = path.substring(len - 4)).equalsIgnoreCase(".dtd") && !ext.equalsIgnoreCase(".ent") && !ext.equalsIgnoreCase(".mod");
    }

    protected boolean isWhitelistEnabled() {
        return this.whitelist != null;
    }

    protected boolean isInvalidProtocol(String protocol) {
        return !protocol.equals("http") && !protocol.equals("https");
    }

    protected boolean isWhitelistedHost(String host) {
        return this.whitelist.contains(host.toLowerCase(Locale.ROOT));
    }

    protected URLConnection openConnection(URL url) throws IOException {
        return url.openConnection();
    }

    protected void connect(URLConnection con) throws IOException {
        con.setConnectTimeout(60000);
        dtdLoader.connect(con);
    }

    protected boolean isValidContentType(String conType) {
        return conType != null && (conType.equals("application/xml-dtd") || conType.equals("text/xml-external-parsed-entity") || conType.equals("application/xml-external-parsed-entity"));
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    public InputSource resolveEntity(DocumentType dtDecl) throws SAXException, IOException {
        return this.resolveEntity(dtDecl.getName(), dtDecl.getPublicId(), dtDecl.getBaseURI(), dtDecl.getSystemId());
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    private static DTDLoader createDTDLoader() {
        DTDLoader loader;
        try {
            Class<?> cl = Class.forName("io.sf.carte.doc.xml.dtd.SMDTDLoader");
            Constructor<?> ctor = cl.getConstructor(new Class[0]);
            loader = (DTDLoader)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            loader = new SimpleDTDLoader();
        }
        return loader;
    }

    private static class SimpleDTDLoader
    extends DTDLoader {
        private SimpleDTDLoader() {
        }

        @Override
        void connect(URLConnection con) throws IOException {
            con.connect();
        }

        @Override
        Reader loadDTDfromClasspath(ClassLoader loader, String dtdFilename) {
            InputStream is = loader != null ? loader.getResourceAsStream(dtdFilename) : LocalEntityResolver.class.getResourceAsStream(dtdFilename);
            if (is == null) {
                is = ClassLoader.getSystemResourceAsStream(dtdFilename);
            }
            InputStreamReader re = null;
            if (is != null) {
                re = new InputStreamReader(is, StandardCharsets.UTF_8);
            }
            return re;
        }
    }

    static abstract class DTDLoader {
        DTDLoader() {
        }

        abstract void connect(URLConnection var1) throws IOException;

        abstract Reader loadDTDfromClasspath(ClassLoader var1, String var2);
    }
}

