/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;
import org.xwiki.xml.internal.html.FontTagTransformation;

@Component
@Named(value="font")
@Singleton
public class FontFilter
extends AbstractHTMLFilter {
    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        List<Element> fontTags = this.filterDescendants(document.getDocumentElement(), new String[]{"font"});
        for (Element fontTag : fontTags) {
            Element span = document.createElement("span");
            this.moveChildren(fontTag, span);
            Map<String, String> attributes = Arrays.stream(DOMUtil.getAttrs((Element)fontTag)).collect(Collectors.toMap(Attr::getName, Attr::getValue));
            new FontTagTransformation().applyTagTransformations(attributes).forEach(span::setAttribute);
            fontTag.getParentNode().insertBefore(span, fontTag);
            fontTag.getParentNode().removeChild(fontTag);
        }
    }
}

