/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.xwiki.tool.xar.AbstractXARMojo;

public abstract class AbstractVerifyMojo
extends AbstractXARMojo {
    protected static final String AUTHOR = "xwiki:XWiki.Admin";
    protected static final String VERSION = "1.1";
    private static final String EXTENSION = ".xml";
    private static final Pattern TRANSLATION_PATTERN = Pattern.compile("(.*)\\..*\\.xml");
    protected boolean force;
    protected String defaultLanguage;
    protected boolean formatLicense;
    protected String commonsVersion;
    private List<String> contentPages;
    private List<String> technicalPages;
    private MavenSession mavenSession;
    private BuildPluginManager pluginManager;
    private List<Pattern> contentPagePatterns;
    private List<Pattern> technicalPagePatterns;

    protected void initializePagePatterns() {
        this.contentPagePatterns = this.initializationPagePatterns(this.contentPages);
        this.technicalPagePatterns = this.initializationPagePatterns(this.technicalPages);
    }

    private List<Pattern> initializationPagePatterns(List<String> pageRegexes) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (pageRegexes != null) {
            for (String pageRegex : pageRegexes) {
                patterns.add(Pattern.compile(pageRegex));
            }
        }
        return patterns;
    }

    protected Collection<File> getXARXMLFiles() throws MojoFailureException {
        File resourcesDir = this.getResourcesDirectory();
        ArrayList<File> files = new ArrayList<File>();
        if (resourcesDir.exists()) {
            Iterator resources;
            PlexusIoFileResourceCollection collection = new PlexusIoFileResourceCollection();
            collection.setBaseDir(resourcesDir);
            IncludeExcludeFileSelector fs = new IncludeExcludeFileSelector();
            fs.setIncludes(this.getIncludes());
            fs.setExcludes(this.getExcludes());
            IncludeExcludeFileSelector fs2 = new IncludeExcludeFileSelector();
            fs2.setExcludes(new String[]{"package.xml"});
            FileSelector[] selectors = new FileSelector[]{fs, fs2};
            collection.setFileSelectors(selectors);
            try {
                resources = collection.getResources();
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to get list of XAR XML files", (Throwable)e);
            }
            while (resources.hasNext()) {
                PlexusIoResource resource = (PlexusIoResource)resources.next();
                if (!resource.isFile()) continue;
                files.add(new File(collection.getBaseDir(), resource.getName()));
            }
        }
        return files;
    }

    protected String guessDefaultLanguage(File file, Collection<File> xwikiXmlFiles) {
        String fileName = file.getName();
        String language = this.guessDefaultLanguageForPatterns(fileName, this.technicalPagePatterns, "");
        if (language != null) {
            return language;
        }
        language = this.guessDefaultLanguageForPatterns(fileName, this.contentPagePatterns, this.defaultLanguage);
        if (language != null) {
            return language;
        }
        language = "";
        Matcher matcher = TRANSLATION_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            language = this.defaultLanguage;
        } else {
            String prefix = StringUtils.substringBeforeLast((String)fileName, (String)EXTENSION);
            Pattern translationPattern = Pattern.compile(String.format("%s\\..*\\.xml", Pattern.quote(prefix)));
            for (File xwikiXmlFile : xwikiXmlFiles) {
                Matcher translationMatcher = translationPattern.matcher(xwikiXmlFile.getName());
                if (!translationMatcher.matches()) continue;
                language = this.defaultLanguage;
                break;
            }
        }
        return language;
    }

    private String guessDefaultLanguageForPatterns(String fileName, List<Pattern> patterns, String defaultLanguage) {
        String language = null;
        if (patterns != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(fileName).matches()) continue;
                return defaultLanguage;
            }
        }
        return language;
    }

    protected String getXWikiCommonsVersion() {
        String version = this.commonsVersion;
        if (version == null) {
            version = this.project.getVersion();
        }
        return version;
    }

    protected void executeLicenseGoal(String goal) throws MojoExecutionException {
        Dependency dep = new Dependency();
        dep.setGroupId("org.xwiki.commons");
        dep.setArtifactId("xwiki-commons-tool-verification-resources");
        dep.setVersion(this.getXWikiCommonsVersion());
        Plugin licensePlugin = MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.mycila"), (String)MojoExecutor.artifactId((String)"license-maven-plugin"), (String)MojoExecutor.version((String)"2.6"));
        licensePlugin.setDependencies(Collections.singletonList(dep));
        MojoExecutor.executeMojo((Plugin)licensePlugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"header"), (String)"license.txt"), MojoExecutor.element((String)MojoExecutor.name((String)"strictCheck"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"headerDefinitions"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"headerDefinition"), (String)"license-xml-definition.xml")}), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"src/main/resources/**/*.xml")})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }
}

