/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.xwiki.tool.xar.AbstractVerifyMojo;
import org.xwiki.tool.xar.XWikiXMLWriter;
import org.xwiki.tool.xar.internal.XWikiDocument;

@Mojo(name="format", threadSafe=true)
public class FormatMojo
extends AbstractVerifyMojo {
    private static final VersionScheme VERSIONSCHEME = new GenericVersionScheme();
    @Parameter(property="pretty", readonly=true)
    private boolean pretty = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getProject().getPackaging().equals("xar") || this.force) {
            if (this.formatLicense) {
                this.getLog().info((CharSequence)"Adding missing XAR XML license headers...");
                this.executeLicenseGoal("format");
            }
            this.getLog().info((CharSequence)"Formatting XAR XML files...");
            this.initializePatterns();
            Collection<File> xmlFiles = this.getXARXMLFiles();
            for (File file : xmlFiles) {
                try {
                    this.format(file, this.guessDefaultLanguage(file, xmlFiles));
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format("Failed to format file [%s]", file), e);
                }
            }
        } else {
            this.getLog().info((CharSequence)"Not a XAR module, skipping reformatting...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void format(File file, String defaultLanguage) throws InvalidVersionSpecificationException, IOException, DocumentException {
        XWikiXMLWriter writer;
        SAXReader reader = new SAXReader();
        Document domdoc = reader.read(file);
        this.format(file.getName(), domdoc, defaultLanguage);
        if (this.pretty) {
            OutputFormat format = new OutputFormat("  ", true, "UTF-8");
            format.setExpandEmptyElements(false);
            writer = new XWikiXMLWriter(new FileOutputStream(file), format);
        } else {
            writer = new XWikiXMLWriter(new FileOutputStream(file));
        }
        try {
            writer.setVersion(this.getXMLVersion(domdoc));
            writer.write(domdoc);
        }
        finally {
            writer.close();
        }
        String parentName = file.getParentFile().getName();
        this.getLog().info((CharSequence)String.format("  Formatting [%s/%s]... ok", parentName, file.getName()));
    }

    private String getXMLVersion(Document domdoc) throws InvalidVersionSpecificationException {
        String versionString = domdoc.getRootElement().attributeValue("version");
        if (versionString != null) {
            Version version13 = VERSIONSCHEME.parseVersion("1.3");
            Version version = VERSIONSCHEME.parseVersion(versionString);
            if (version.compareTo((Object)version13) >= 0) {
                return "1.1";
            }
        }
        return "1.0";
    }

    private void format(String fileName, Document domdoc, String defaultLanguage) {
        Node node = domdoc.selectSingleNode("xwikidoc/author");
        if (node != null) {
            node.setText("xwiki:XWiki.Admin");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/contentAuthor")) != null) {
            node.setText("xwiki:XWiki.Admin");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/creator")) != null) {
            node.setText("xwiki:XWiki.Admin");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/version")) != null) {
            node.setText("1.1");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/minorEdit")) != null) {
            node.setText("false");
        }
        for (Node attachmentAuthorNode : domdoc.selectNodes("xwikidoc/attachment/author")) {
            attachmentAuthorNode.setText("xwiki:XWiki.Admin");
        }
        Element element = (Element)domdoc.selectSingleNode("xwikidoc/defaultLanguage");
        if (element != null) {
            if (StringUtils.isEmpty((CharSequence)defaultLanguage)) {
                this.removeContent(element);
            } else {
                element.setText(defaultLanguage);
            }
        }
        if ((element = (Element)domdoc.selectSingleNode("xwikidoc/comment")) != null) {
            this.removeContent(element);
        }
        element = (Element)domdoc.selectSingleNode("xwikidoc/hidden");
        if (this.isTechnicalPage(fileName)) {
            element.setText("true");
        }
        String documentName = "";
        try {
            documentName = XWikiDocument.readDocumentReference(domdoc);
        }
        catch (DocumentException e) {
            this.getLog().error((CharSequence)"Failed to get the document reference", (Throwable)e);
        }
        if (!this.skipDates && !this.skipDatesDocumentList.contains(documentName)) {
            this.removeNodes("xwikidoc/creationDate", domdoc);
            this.removeNodes("xwikidoc/date", domdoc);
            this.removeNodes("xwikidoc/contentUpdateDate", domdoc);
            this.removeNodes("xwikidoc//attachment/date", domdoc);
        }
    }

    private void removeContent(Element element) {
        if (element.hasContent()) {
            ((Node)element.content().get(0)).detach();
        }
    }

    private void removeNodes(String xpathExpression, Document domdoc) {
        List nodes = domdoc.selectNodes(xpathExpression);
        for (Node node : nodes) {
            node.detach();
        }
    }
}

