/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.component;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"org.xwiki.component.annotation.Component"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ComponentCheckerAnnotationProcessor
extends AbstractProcessor {
    private static final String SINGLETON_CLASS_NAME = "javax.inject.Singleton";
    private static final String INSTANTIATION_STRATEGY_CLASS_NAME = "org.xwiki.component.annotation.InstantiationStrategy";
    private List<String> declarations;
    private URI componentsDeclarationLocation;
    private boolean skip;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.NOTE, "Checking validity of components.txt files...");
        try {
            this.declarations = this.parseComponentsTxtFile(processingEnvironment);
        }
        catch (FileNotFoundException e) {
            this.declarations = Collections.emptyList();
        }
        catch (IllegalArgumentException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Failed to locate any [META-INF/components.txt]. Could be caused by a compilation with the AspectJ compiler. Aborting check.");
            this.skip = true;
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Failed to parse [META-INF/components.txt]. Reason: [%s]", this.getThrowableString(e)));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment environment) {
        if (this.skip || annotations.size() == 0) {
            return false;
        }
        Class<? extends Annotation> componentAnnotationClass = this.loadAnnotationClass("org.xwiki.component.annotation.Component");
        if (componentAnnotationClass == null) {
            return false;
        }
        for (Element element : environment.getElementsAnnotatedWith(componentAnnotationClass)) {
            TypeElement classElement = (TypeElement)element;
            String binaryName = this.processingEnv.getElementUtils().getBinaryName(classElement).toString();
            boolean isStaticRegistration = this.isStaticRegistration(classElement, componentAnnotationClass);
            if (!this.declarations.contains(binaryName) && isStaticRegistration) {
                if (this.componentsDeclarationLocation == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("There's no [META-INF/components.txt] file and thus Component [%s] isn't declared! Consider adding a components.txt file or if it's normal use the \"staticRegistration\" parameter as in \"@Component(staticRegistration = false)\"", binaryName));
                } else {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Component [%s] isn't declared in [%s]! Consider adding it or if it's normal use the \"staticRegistration\" parameter as in \"@Component(staticRegistration = false)\"", binaryName, this.componentsDeclarationLocation));
                }
            } else if (this.declarations.contains(binaryName) && !isStaticRegistration) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Component [%s] is declared in [%s] but it's also declared with a \"staticRegistration\" parameter with a [false] value, e.g. \"@Component(staticRegistration = false\". You need to fix that!", binaryName, this.componentsDeclarationLocation));
            }
            Class<? extends Annotation> singletonAnnotationClass = this.loadAnnotationClass(SINGLETON_CLASS_NAME);
            Class<? extends Annotation> instantationStrategyAnnotationClass = this.loadAnnotationClass(INSTANTIATION_STRATEGY_CLASS_NAME);
            if (singletonAnnotationClass == null || instantationStrategyAnnotationClass == null) {
                return false;
            }
            Annotation singletonAnnotation = classElement.getAnnotation(singletonAnnotationClass);
            Annotation instantationStrategyAnnotation = classElement.getAnnotation(instantationStrategyAnnotationClass);
            if (singletonAnnotation != null || instantationStrategyAnnotation != null) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Component class [%s] must have either the [%s] or the [%s] annotation defined on it.", binaryName, SINGLETON_CLASS_NAME, INSTANTIATION_STRATEGY_CLASS_NAME));
        }
        return true;
    }

    private Class<? extends Annotation> loadAnnotationClass(String annotationClassAsString) {
        Class<Annotation> annotationClass;
        try {
            annotationClass = this.getClass().getClassLoader().loadClass(annotationClassAsString).asSubclass(Annotation.class);
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("Failed to load Annotation class [%s]. No check was done on it. Reason: [%s]", annotationClassAsString, this.getThrowableString(e)));
            annotationClass = null;
        }
        return annotationClass;
    }

    private boolean isStaticRegistration(TypeElement classElement, Class<? extends Annotation> componentAnnotationClass) {
        Boolean isStaticRegistration = true;
        try {
            Annotation annotation = classElement.getAnnotation(componentAnnotationClass);
            isStaticRegistration = (Boolean)componentAnnotationClass.getMethod("staticRegistration", new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Failed to find out if Component annotation is statically registered or not! Reason: [%s]", this.getThrowableString(e)));
        }
        return isStaticRegistration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> parseComponentsTxtFile(ProcessingEnvironment processingEnvironment) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        FileObject fo = processingEnvironment.getFiler().getResource(StandardLocation.SOURCE_PATH, "", "META-INF/components.txt");
        this.componentsDeclarationLocation = fo.toUri();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Checking content of [%s]", fo.toUri()));
        try (BufferedReader in = new BufferedReader(fo.openReader(true));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                if (inputLine.trim().length() <= 0) continue;
                try {
                    String[] chunks = inputLine.split(":");
                    if (chunks.length > 1) {
                        results.add(chunks[1]);
                        continue;
                    }
                    results.add(chunks[0]);
                }
                catch (Exception e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Failed to parse [%s] from [%s]. Reason [%s]", inputLine, fo.toUri(), this.getThrowableString(e)));
                }
            }
            return results;
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Failed to read [%s]. Reason: [%s]", fo.toUri(), this.getThrowableString(e)));
            throw e;
        }
    }

    private String getThrowableString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

