/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.checkstyle;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class ScriptServiceCheck
extends Check {
    private String packageName;

    public int[] getDefaultTokens() {
        return new int[]{14, 16};
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                FullIdent ident = FullIdent.createFullIdent((DetailAST)ast.getLastChild().getPreviousSibling());
                this.packageName = ident.getText();
                break;
            }
            case 14: {
                String className = ast.findFirstToken(58).getText();
                System.out.println("WWWW checking class " + className + " in package " + this.packageName);
                if (!className.endsWith("ScriptService") || !this.packageName.contains("internal")) break;
                this.log(ast.getLineNo(), "Script Service implementation [" + className + "] in package [" + this.packageName + "] should not be located in the internal package", new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }
}

